<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Meta Tag -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name='copyright' content=''>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<!-- Title Tag  -->
    <title><?php echo e(isset($seo_title) ? $seo_title : get_option('site_title', config('app.name'))); ?></title>

    <meta name="keywords" content="<?php echo e(isset($meta_keywords) ? $meta_keywords : get_option('meta_keywords')); ?>"/>
    <meta name="description" content="<?php echo e(isset($meta_description) ? $meta_description : get_option('meta_description')); ?>"/>

	<!-- Favicon -->
	<link rel="icon" type="image/png" href="<?php echo e(get_favicon()); ?>">

	<!-- Web Font -->
	<link href="https://fonts.googleapis.com/css?family=Poppins:200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i&display=swap" rel="stylesheet">
	
	<!-- StyleSheet -->
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/bootstrap.css')); ?>">
	<!-- Magnific Popup -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/magnific-popup.min.css')); ?>">
	<!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/font-awesome.css')); ?>">
	<!-- Fancybox -->
	<link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/jquery.fancybox.min.css')); ?>">
	<!-- Themify Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/themify-icons.css')); ?>">
	<!-- Nice Select CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/niceselect.css')); ?>">
	<!-- Animate CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/animate.css')); ?>">
	<!-- Flex Slider CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/flex-slider.min.css')); ?>">
    <!-- Jquery Ui -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/jquery-ui.css')); ?>">
	<!-- Owl Carousel -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/owl-carousel.css')); ?>">
	<!-- Slicknav -->
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/slicknav.min.css')); ?>">

    <link href="<?php echo e(asset('public/backend/plugins/jquery-toast-plugin/jquery.toast.min.css')); ?>" rel="stylesheet" />
	
	<link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/reset.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('public/theme/default/style.css?v=1.1')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/theme/default/css/responsive.css?v=1.1')); ?>">  

    <?php echo $__env->make('theme.default.components.custom_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
	<?php echo $__env->make('layouts.others.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript">
    	var _url = "<?php echo e(url('')); ?>";
    </script>
    
</head>
<body class="js">
	<!-- Preloader -->
	<div class="preloader">
		<div class="preloader-inner">
			<div class="preloader-icon">
				<span></span>
				<span></span>
			</div>
		</div>
	</div>
	<!-- End Preloader -->	
	
	<?php if(\Session::has('checkout_error')): ?>
		<div class="alert alert-danger rounded-0">
			<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
			<p class="text-center m-0 text-white"><?php echo e(session('checkout_error')); ?></p>
		</div>
	<?php endif; ?>
	
	<!-- Header -->
	<header class="header shop">
		<!-- Topbar -->
		<div class="topbar">
			<div class="container">
				<div class="row">
					<div class="col-lg-5 col-md-12 col-12">
						<!-- Top Left -->
						<div class="top-left">
							<ul class="list-main">
								<li><i class="ti-headphone-alt"></i> <?php echo e(get_option('phone')); ?></li>
								<li><i class="ti-email"></i> <?php echo e(get_option('email')); ?></li>
							</ul>
						</div>
						<!--/ End Top Left -->
					</div>
					<div class="col-lg-7 col-md-12 col-12">
						<!-- Top Right -->
						<div class="right-content">
							<ul class="list-main">
								<li>
									<div class="dropdown show">
									  <a class="dropdown-toggle" href="#" role="button" id="languageSwitcher" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									    <i class="ti-world"></i>  
									    <?php echo e(session('language') =='' ? get_option('language') : session('language')); ?>

									  </a>

									  <div class="dropdown-menu" aria-labelledby="languageSwitcher">
	
									    <?php $__currentLoopData = get_language_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<a class="dropdown-item" href="<?php echo e(url('/')); ?>?language=<?php echo e($language); ?>"><?php echo e($language); ?></a>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									  </div>
									</div>
								</li>
								<li>
									<div class="dropdown show">
									  <a class="dropdown-toggle" href="#" role="button" id="currencySwitcher" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									    <i class="ti-credit-card"></i>
									    <?php echo e(session('currency') =='' ? currency() : session('currency')); ?>

									  </a>

									  <div class="dropdown-menu" aria-labelledby="currencySwitcher">
									  	<?php $__currentLoopData = \App\Currency::where('status',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									    	<a class="dropdown-item" href="?currency=<?php echo e($currency->name); ?>"><?php echo e($currency->name); ?></a>
									    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									  </div>
									</div>
								</li>
								
								<?php if(! Auth::check()): ?>
									<li><i class="ti-lock"></i><a href="<?php echo e(url('/sign_in')); ?>"><?php echo e(_lang('Login')); ?></a></li>
								<?php else: ?>
									<li><i class="ti-user"></i> <a href="<?php echo e(url('/my_account')); ?>"><?php echo e(_lang('My account')); ?></a></li>
									<li><i class="ti-power-off"></i><a href="<?php echo e(url('/sign_out')); ?>"><?php echo e(_lang('Logout')); ?></a></li>
								<?php endif; ?>
							</ul>
						</div>
						<!-- End Top Right -->
					</div>
				</div>
			</div>
		</div>
		<!-- End Topbar -->
		<div class="middle-inner">
			<div class="container">
				<div class="row">
					<div class="col-lg-2 col-md-2 col-12">
						<!-- Logo -->
						<div class="logo">
							<a href="<?php echo e(url('')); ?>"><img src="<?php echo e(get_logo()); ?>" alt="logo"></a>
						</div>
						<!--/ End Logo -->				

						<!-- Search Form -->
						<div class="search-top">
							<div class="top-search"><a href="#0"><i class="ti-search"></i></a></div>
							<!-- Search Form -->
							<div class="search-top">
								<form class="search-form" action="<?php echo e(url('/shop')); ?>">
									<input type="text" class="search-products" placeholder="<?php echo e(_lang('Search here')); ?>..." name="search">
									<button value="search" type="submit"><i class="ti-search"></i></button>
								</form>
							</div>
							<!--/ End Search Form -->
						</div>
						<!--/ End Search Form -->
						
						<div class="mobile-nav"></div>
						
					</div>
					<div class="col-lg-8 col-md-7 col-12">
						<div class="search-bar-top">
							<form action="<?php echo e(url('/shop')); ?>">			
								<div class="search-bar">
									<?php $search_category = isset($_GET['category']) ? $_GET['category'] : ''; ?>
									<select class="nice-select" name="category" id="search-category">
										<option value="all"><?php echo e(_lang('All')); ?></option>
										<?php $__currentLoopData = App\Entity\Category\Category::where('parent_id',null)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($category->slug); ?>" <?php echo e($search_category == $category->slug ? 'selected' : ''); ?>><?php echo e($category->translation->name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								
									<input name="search" class="search-products" placeholder="<?php echo e(_lang('Search Products')); ?>" type="search">
									<button class="btnn"><i class="ti-search"></i></button>
								</div>
							</form>
						</div>
					</div>
					<div class="col-lg-2 col-md-3 col-12">
						<div class="right-bar">

							<div class="sinlge-bar">
								<a href="<?php echo e(url('wish_list')); ?>" class="single-icon">
									<i class="fa fa-heart-o" aria-hidden="true"></i>
									<span class="total-count" id="wishlist-count"><?php echo e(auth()->check() ? auth()->user()->wishlist->count() : 0); ?></span>
								</a>
							</div>

							<div class="sinlge-bar shopping" id="mini-cart">
								<?php echo $__env->make('theme.default.components.mini-cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</div>

						</div>
					</div>
					
					<div id="mobile-cart">
						<a href="<?php echo e(url('/cart')); ?>" class="single-icon"><i class="ti-shopping-cart-full"></i> 
							<span class="total-count"><?php echo e(\Cart::getTotalQuantity()); ?></span>
						</a>
					</div>
					
				</div>
			</div>
		</div>
		<!-- Header Inner -->
		<div class="header-inner">
			<div class="container">
				<div class="cat-nav-head">
					<div class="row">
						<?php if(Request::is('/')): ?>
						<div class="col-lg-3">
							<div class="all-category">
								<h3 class="cat-heading">
									<i class="fa fa-bars" aria-hidden="true"></i><?php echo e(_lang('CATEGORIES')); ?>

								</h3>

								<?php echo xss_clean(show_navigation(get_option('category_menu'), 'main-category', 'sub-category', 'sub-category','right')); ?>

							</div>
						</div>
						<?php endif; ?>

						<div class="<?php echo e(Request::is('/') ? 'col-lg-9 col-12' : 'col-lg-12'); ?>">
							<div class="menu-area">
								<!-- Main Menu -->
								<nav class="navbar navbar-expand-lg">
									<div class="navbar-collapse">	
										<div class="nav-inner">	
											<?php echo xss_clean(show_navigation(get_option('primary_menu'), 'nav main-menu menu navbar-nav', 'dropdown', 'dropdown sub-dropdown')); ?>

										</div>
									</div>
								</nav>
								<!--/ End Main Menu -->	
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--/ End Header Inner -->
	</header>
	<!--/ End Header -->
	
	<?php echo $__env->yieldContent('content'); ?>	

	<!-- Quick View Shop -->
	<div class="modal fade" id="quickShop" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span class="ti-close" aria-hidden="true"></span></button>
				</div>
				<div class="modal-body">


				</div>
			</div>
		</div>
	</div>
	<!-- Quick View Shop end -->
	
	<!-- Start Footer Area -->
	<footer class="footer">
		<!-- Footer Top -->
		<div class="footer-top section">
			<div class="container">
				<div class="row">
					<div class="col-lg-5 col-md-6 col-12">
						<!-- Single Widget -->
						<div class="single-footer about">
							<div class="logo">
								<a href="<?php echo e(url('')); ?>"><h4><?php echo e(get_option('site_title')); ?></h4></a>
							</div>

							<p class="text"><?php echo xss_clean(get_trans_option('footer_about_us')); ?></p>
							
						</div>
						<!-- End Single Widget -->
					</div>
					<div class="col-lg-2 col-md-6 col-12">
						<!-- Single Widget -->
						<div class="single-footer links">
							<h4><?php echo e(get_trans_option('footer_menu_1_title')); ?></h4>
							<?php echo xss_clean(show_navigation(get_option('footer_menu_1'))); ?>

						</div>
						<!-- End Single Widget -->
					</div>
					<div class="col-lg-2 col-md-6 col-12">
						<!-- Single Widget -->
						<div class="single-footer links">
							<h4><?php echo e(get_trans_option('footer_menu_2_title')); ?></h4>
							<?php echo xss_clean(show_navigation(get_option('footer_menu_2'))); ?>

						</div>
						<!-- End Single Widget -->
					</div>
					<div class="col-lg-3 col-md-6 col-12">
						<!-- Single Widget -->
						<div class="single-footer links">
							<h4><?php echo e(_lang('My Account')); ?></h4>
							<!-- Single Widget -->
							<ul>
								<li><a href="<?php echo e(url('/my_account/overview')); ?>"><?php echo e(_lang('Account Overview')); ?></a></li>
								<li><a href="<?php echo e(url('/my_account/orders')); ?>"><?php echo e(_lang('My Orders')); ?></a></li>
								<li><a href="<?php echo e(url('/my_account/downloads')); ?>"><?php echo e(_lang('My Downloads')); ?></a></li>
								<li><a href="<?php echo e(url('/my_account/reviews')); ?>"><?php echo e(_lang('My Reviews')); ?></a></li>
								<?php if(auth()->guard()->check()): ?>
									<li><a href="<?php echo e(url('/logout')); ?>"><?php echo e(_lang('Logout')); ?></a></li>
								<?php endif; ?>
							</ul>
							<!-- End Single Widget -->
						</div>
						<!-- End Single Widget -->
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Top -->
		<div class="copyright">
			<div class="container">
				<div class="inner">
					<div class="row">
						<div class="col-lg-6 col-12">
							<div class="left">
								<p><?php echo xss_clean(get_trans_option('copyright_text')); ?></p>
							</div>
						</div>
						<div class="col-lg-6 col-12">
							<div class="right">
								<img src="<?php echo e(get_option('payment_method_image') != '' ? asset('public/uploads/media/'.get_option('payment_method_image')) : asset('public/theme/default/images/payments.png')); ?>" alt="#">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>
	<!-- /End Footer Area -->
 
	<!-- Jquery -->
    <script src="<?php echo e(asset('public/theme/default/js/jquery.min.js')); ?>"></script>

    <script src="<?php echo e(asset('public/theme/default/js/jquery-migrate-3.0.0.js')); ?>"></script>

	<script src="<?php echo e(asset('public/theme/default/js/jquery-ui.min.js')); ?>"></script>
	<!-- Popper JS -->
	<script src="<?php echo e(asset('public/theme/default/js/popper.min.js')); ?>"></script>
	<!-- Bootstrap JS -->
	<script src="<?php echo e(asset('public/theme/default/js/bootstrap.min.js')); ?>"></script>
	<!-- Slicknav JS -->
	<script src="<?php echo e(asset('public/theme/default/js/slicknav.min.js')); ?>"></script>
	<!-- Owl Carousel JS -->
	<script src="<?php echo e(asset('public/theme/default/js/owl-carousel.js')); ?>"></script>
	<!-- Magnific Popup JS -->
	<script src="<?php echo e(asset('public/theme/default/js/magnific-popup.js')); ?>"></script>
	<!-- Waypoints JS -->
	<script src="<?php echo e(asset('public/theme/default/js/waypoints.min.js')); ?>"></script>
	<!-- Countdown JS -->
	<script src="<?php echo e(asset('public/theme/default/js/finalcountdown.min.js')); ?>"></script>
	<!-- Nice Select JS -->
	<script src="<?php echo e(asset('public/theme/default/js/nicesellect.js')); ?>"></script>
	<!-- Flex Slider JS -->
	<script src="<?php echo e(asset('public/theme/default/js/flex-slider.js')); ?>"></script>
	<!-- ScrollUp JS -->
	<script src="<?php echo e(asset('public/theme/default/js/scrollup.js')); ?>"></script>
	<!-- Onepage Nav JS -->
	<script src="<?php echo e(asset('public/theme/default/js/onepage-nav.min.js')); ?>"></script>
	<!-- Easing JS -->
	<script src="<?php echo e(asset('public/theme/default/js/easing.js')); ?>"></script>

	<script src="<?php echo e(asset('public/backend/plugins/jquery-toast-plugin/jquery.toast.min.js')); ?>"></script>
	
	<script src="<?php echo e(asset('public/theme/default/js/typeahead.bundle.js')); ?>"></script>

	<script src="<?php echo e(asset('public/backend/assets/js/print.js')); ?>"></script>
	
	<!-- Active JS -->
	<script src="<?php echo e(asset('public/theme/default/js/active.js?v=1.2')); ?>"></script>

	<!-- Custom JS -->
	<?php echo $__env->yieldContent('js-script'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\baycolorlab\resources\views/theme/default/website.blade.php ENDPATH**/ ?>