

<?php $__env->startSection('content'); ?>
	
<!-- Login Screen -->
<section id="auth"> 
	<div class="container">
		<div class="row">
			<div class="col-md-6 offset-md-3">
				
				<?php if(\Session::has('success')): ?>
					<div class="alert alert-success mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span><?php echo xss_clean(session('success')); ?></span>
					</div>
				<?php endif; ?>

				<?php if(\Session::has('error')): ?>
					<div class="alert alert-danger mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span><?php echo xss_clean(session('error')); ?></span>
					</div>
				<?php endif; ?>

				<div class="login_register">					
					<h3 class="section-heading"><?php echo e(_lang('Sign In')); ?></h3>
					<form action="<?php echo e(url('/sign_in')); ?>" method="post">
						<?php echo csrf_field(); ?>
						<input type="email" name="email" class="form-control" value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(_lang('Email')); ?>" required>
						<input type="password" name="password" class="form-control" placeholder="<?php echo e(_lang('Password')); ?>" required>
						<input type="hidden" name="redirect_to" value="<?php echo e(url()->previous()); ?>">

						<button type="submit" class="btn-login"><?php echo e(_lang('Login')); ?></button>
							
						<?php if(get_option('google_login') == 'enabled'): ?>
		                    <a href="<?php echo e(url('/login/google')); ?>" class="btn btn-google"> <?php echo e(_lang('Continue With Google')); ?></a>
						<?php endif; ?>

		                <?php if(get_option('facebook_login') == 'enabled'): ?>
		                    <a href="<?php echo e(url('/login/facebook')); ?>" class="btn btn-facebook"> <?php echo e(_lang('Continue With Facebook')); ?></a>
		                <?php endif; ?>

						<div class="text-center">
							<a href="<?php echo e(route('password.request')); ?>" class="right_link"><?php echo e(_lang('Forget Your Password?')); ?></a>
						</div>
					</form>
				</div>
				
				<div class="text-center">
					<a href="<?php echo e(url('/sign_up')); ?>" class="create-account-link"><?php echo e(_lang('Create an Account')); ?></a>
                </div>
			</div>
		</div>
	</div>
</section>
<!--/ End Login Screen -->
		

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script src="<?php echo e(asset('public/theme/default/js/cart.js?v=1.1')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.baycolorlab.website', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devhub/baycolorlab.devhub.digtalsdesigns.com/resources/views/theme/baycolorlab/customer/sign_in.blade.php ENDPATH**/ ?>