

<?php $__env->startSection('content'); ?>
<style>
    .modal {
        display: none; /* Hidden by default */
        position: fixed;
        z-index: 1;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        background-color: #fff;
        margin: 15% auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
        max-width: 500px;
        text-align: center;
    }

    .close {
        color: #aaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
    }
</style>
<section class="customizer">
    <div class="row">
        <div class="col-md-12">
            <div class="customizer-top">
                <div class="my-photo-tab">
                    <a href="#" class="myphoto-btn"><i class="fa-regular fa-images"></i> MY PHOTOS</a>
                </div>
                <div class="upload-photo-tab">
                    <a class="upload-photo-btn" href="javascript:void(0);" onclick="openModal()">
                        <i class="fa-solid fa-cloud-arrow-up"></i> UPLOAD PHOTOS
                    </a>
                    <a href="<?php echo e(url('/computer-upload/'.$data->id)); ?>" class="refresh-btn"><i class="fa-solid fa-arrows-rotate"></i></a>
                    <p id="selected-count"><?php echo e(count(session('uploaded_images'))); ?> Selected</p>
                </div>
            </div>
        </div>
        <div id="uploadModal" class="modal">
            <div class="modal-content">
                <form action="<?php echo e(route('upload')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <span class="close" onclick="closeModal()">&times;</span>
                    <h2>Upload Photos</h2>
                    <input type="text" hidden name="order_id" value="<?php echo e($data->id); ?>"/>
                    <input type="file" id="MemberImage" name="images[]" class="dropify"data-height="220" multiple/>
                    <input type="submit" class="btn btn-primary" value="Upload">
                </form>
            </div>
        </div>
        <div class="col-md-2">
            <div class="number-pics">
                <div class="my-pics-butn">
                    <a class="my-bnt" href="#">My Photos <span id="photo-count"><?php echo e(count(session('uploaded_images'))); ?></span></a>
                    <?php $__currentLoopData = session('uploaded_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="image-item">
                            <p><?php echo e(str_replace("uploads/users/","", $image)); ?> <a href="#" class="remove-image" data-image="<?php echo e($image); ?>"><i class="fa-solid fa-xmark"></i></a></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php if(!Auth::check()): ?>
                <div class="login-signup-btns">
                    <a href="<?php echo e(url('sign_in')); ?>">Sign in</a>
                    <a href="<?php echo e(url('sign_up')); ?>">Join</a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-md-8">
            <div class="main-customiser">
                <div class="main-customiser-top">
                    <div class="options-left">
                        <a href="#"><i class="fa-regular fa-square-check"></i> Select All</a>
                        <a href="#"><i class="fa-regular fa-calendar-days"></i> Newest First</a>
                        <div class="pls-mkin">
                            <a href="#" id="increase-size"><i class="fa-solid fa-circle-plus"></i></a>
                            <a href="#" id="decrease-size"><i class="fa-solid fa-circle-minus"></i></a>
                            Thumb size
                        </div>
                    </div>
                    <div class="options-right"> 
                        <a href="#" id="download-all"><i class="fa-solid fa-download"></i> Download All</a>
                    </div>
                </div>
                <div class="custom-img-set" id="image-container">
                    <?php if(session('uploaded_images')): ?>
                        <?php $__currentLoopData = session('uploaded_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-3 image-item">
                                <img src="<?php echo e(asset('public/'.$image)); ?>" alt="Uploaded Image" class="img-thumbnail thumbnail">  
                                <p><?php echo e(str_replace("uploads/users/","", $image)); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>No images uploaded.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-md-2 right-qan">
            <div class="right-side-quantiies">
                <div class="select-type">
                    <select name="image_selection" id="select_image">
                         <?php $__currentLoopData = session('uploaded_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option data-label="<?php echo e(str_replace("uploads/users/","", $image)); ?>" value="<?php echo e(str_replace("uploads/users/","", $image)); ?>"><?php echo e(str_replace("uploads/users/","", $image)); ?></option>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select name="select_type_of_paper" id="select_type_of_paper">
                        <?php $__currentLoopData = App\Paper::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($loop->index+1); ?>" data-label="<?php echo e($data->name); ?>" data-price="<?php echo e($data->price); ?>"><?php echo e($data->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="sizes-pic">
                    <?php $__currentLoopData = App\Sizes::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="size-one">
                        <label><?php echo e($data->size); ?> <span class="price">$<?php echo e($data->price); ?></span></label>
                        <input type="number" class="quantity" min="0" value="0" data-size="<?php echo e($data->size); ?>">
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="check-ntn">
                    <form action="<?php echo e(route('add_to_cart')); ?>" id="checkout-form" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                    <input type="text" hidden id="user_check" value="<?php echo e(Auth::check() ? 'true' : 'false'); ?>"/>
                    <input type="text" hidden name="order_id" id="order_id" value="<?php echo e($data->id); ?>"/>
                    <textarea id="orderNote" name="order_info" placeholder="Your order details will appear here..."></textarea>
                    <textarea id="orderImages" hidden name="order_images" readonly><?php echo e(json_encode(session('uploaded_images'))); ?></textarea>
                    <input type="text" id="total" hidden name="total" value="">
                    <p>Cart Subtotal: <span id="subtotal">$0.00</span></p>
                        <input id="btnn" type="submit" value="Check Out">
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
    document.getElementById('checkout-form').addEventListener('submit', function(event) {
        const userCheck = document.getElementById('user_check').value;

        if (userCheck === 'false') {
            event.preventDefault(); // Prevent form submission
            alert('Please log in first.'); // Alert message
        }
        // If true, the form will submit normally
    });
</script>
<script>
    // Prices for each paper type
    const paperPrices = {};
    <?php $__currentLoopData = App\Paper::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    paperPrices[<?php echo e($loop->index + 1); ?>] = { price: <?php echo e($data->price); ?>, label: "<?php echo e($data->name); ?>" };
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    const selectType = document.getElementById('select_type_of_paper');
    const selectImage = document.getElementById('select_image');
    const priceLabels = document.querySelectorAll('.size-one .price');
    const quantities = document.querySelectorAll('.quantity');
    const subtotalElement = document.getElementById('subtotal');
    const orderNote = document.getElementById('orderNote');
    
    // Object to store quantities and details for each image and paper type combination
    const storedEntries = {}; // Keyed by image name and paper type
    
    function updatePrices() {
        const selectedType = selectType.value;
        const pricePerSize = paperPrices[selectedType].price;
    
        // Update each price label
        priceLabels.forEach((label) => {
            label.textContent = `$${pricePerSize.toFixed(2)}`;
        });
    
        // Load previously selected quantities and paper type for the current image
        const selectedImageName = selectImage.options[selectImage.selectedIndex].getAttribute('data-label'); // Use selected image name
        // Reset inputs if there's no stored data for the selected image and paper type
        quantities.forEach((input) => {
            const size = input.dataset.size;
            input.value = 0; // Reset to 0 as we are going to create a new entry
        });
    
        // Recalculate subtotal and update note
        calculateSubtotal();
    }
    
    function calculateSubtotal() {
        let subtotal = 0;
        const orderEntries = []; // Array to store order entries
    
        // Loop through stored entries and build the order entries
        Object.keys(storedEntries).forEach(key => {
            const [image, type] = key.split('|'); // Use array destructuring
            const imageDetails = storedEntries[key];
            const paperType = imageDetails.type;
            const pricePerSize = paperPrices[paperType].price;
    
            // Generate note for the current image
            Object.keys(imageDetails.quantities).forEach(size => {
                const quantity = imageDetails.quantities[size];
                const totalPrice = quantity * pricePerSize;
    
                if (quantity > 0) {
                    subtotal += totalPrice;
    
                    // Add entry for the order note
                    orderEntries.push(`${image} - ${paperPrices[paperType].label} x ${quantity} (${size}) - $${totalPrice.toFixed(2)}`);
                }
            });
        });
    
        // Update subtotal display
        subtotalElement.textContent = `$${subtotal.toFixed(2)}`;
        $('#total').val(subtotal.toFixed(2));
    
        // Update the order note with all entries
        orderNote.value = orderEntries.length > 0 ? orderEntries.join("\n") : "Your order details will appear here...";
    }
    
    // Store quantities and details for the current image and paper type
    function storeCurrentDetails() {
        const selectedImage = selectImage.options[selectImage.selectedIndex].getAttribute('data-label'); // Correctly fetch selected image name
        const selectedType = selectType.value;
        const key = `${selectedImage}|${selectedType}`; // Create a unique key for the combination
    
        // Ensure there's an object to hold quantities for the selected image and type
        if (!storedEntries[key]) {
            storedEntries[key] = {
                type: selectedType,
                quantities: {}
            };
        }
    
        // Store quantities for the selected image
        quantities.forEach((input) => {
            const size = input.dataset.size;
            const quantity = parseInt(input.value, 10) || 0;
            storedEntries[key].quantities[size] = quantity;
        });
    
        calculateSubtotal();
    }
    
    // Event listener to update prices when paper type changes
    selectType.addEventListener('change', () => {
        storeCurrentDetails(); // Store current details before changing type
        updatePrices(); // Update prices for the new paper type
    });
    
    // Event listener to update order details when image selection changes
    selectImage.addEventListener('change', () => {
        storeCurrentDetails(); // Store the current details before changing the image
        updatePrices(); // Update prices and quantities for the new image
    });
    
    // Event listeners to recalculate subtotal when quantity changes
    quantities.forEach((input) => {
        input.addEventListener('input', () => {
            storeCurrentDetails(); // Store current details when quantity changes
        });
    });
    
    // Initialize prices on page load
    updatePrices();

</script>
<script>
    document.getElementById('download-all').addEventListener('click', function(event) {
        event.preventDefault(); // Prevent default anchor behavior

        // Get all uploaded images from session
        let images = <?php echo json_encode(session('uploaded_images'), 15, 512) ?>;

        // Iterate through each image and create a download link
        images.forEach(function(image) {
            const link = document.createElement('a');
            link.href = '<?php echo e(asset('public/')); ?>' + '/' + image; // Full path to the image
            link.download = image.split('/').pop(); // Extract filename for download
            document.body.appendChild(link); // Append link to the body
            link.click(); // Trigger download
            document.body.removeChild(link); // Remove link after downloading
        });
    });
</script>
<script>
    document.getElementById('increase-size').addEventListener('click', function(event) {
        console.log('plus')
        event.preventDefault(); // Prevent default anchor behavior
        changeImageSize(1.2); // Increase size by 20%
    });

    document.getElementById('decrease-size').addEventListener('click', function(event) {
        console.log('minus')
        event.preventDefault(); // Prevent default anchor behavior
        changeImageSize(0.8); // Decrease size by 20%
    });

    function changeImageSize(scale) {
        // Select all images with the 'thumbnail' class
        const images = document.querySelectorAll('.thumbnail');
        images.forEach(function(image) {
            const currentWidth = image.offsetWidth;
            const currentHeight = image.offsetHeight;

            // Set the new width and height based on the scale
            image.style.width = (currentWidth * scale) + 'px';
            image.style.height = (currentHeight * scale) + 'px';
        });
    }
</script>
<script>
    // Function to update photo count and image display
    function updateImageDisplay(images) {
        const container = document.getElementById('image-container');
        container.innerHTML = ''; // Clear current images
        const countDisplay = document.getElementById('selected-count');
        const orderImages = document.getElementById('orderImages');

        if (images.length === 0) {
            container.innerHTML = '<p>No images uploaded.</p>';
            countDisplay.textContent = '0 Selected'; // Update count display
        } else {
            images.forEach(image => {
                const imageItem = document.createElement('div');
                imageItem.className = 'col-md-3 image-item';
                imageItem.innerHTML = `
                    <img src="${'<?php echo e(asset('public/')); ?>'}/${image}" alt="Uploaded Image" class="img-thumbnail thumbnail">
                    
                `;
                container.appendChild(imageItem);
            });

            // Update the photo count
            document.getElementById('photo-count').textContent = images.length;

            // Reattach event listeners for remove-image
            countDisplay.textContent = `${images.length} Selected`; // Update count display
            orderImages.value = JSON.stringify(images); // Update the textarea with the current images
            attachRemoveEventListeners();
        }
    }

    // Function to attach click event to remove-image links
    function attachRemoveEventListeners() {
        document.querySelectorAll('.remove-image').forEach(function(link) {
            link.addEventListener('click', function(event) {
                event.preventDefault(); // Prevent default link behavior

                const imageName = this.getAttribute('data-image'); // Get the image name from data attribute
                
                // Send an AJAX request to remove the image from the session
                fetch('https://baycolorlab.devhub.digtalsdesigns.com/remove-image', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' // Include CSRF token for security
                    },
                    body: JSON.stringify({ image: imageName }) // Send the image name
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        this.closest('.image-item').remove(); 
                        updateImageDisplay(data.images);
                    } else {
                        alert('Failed to remove image: ' + data.message);
                    }
                })
                .catch(error => console.error('Error:', error));
            });
        });
    }

    // Initial setup of event listeners
    attachRemoveEventListeners();
</script>
<script>
function openModal() {
    document.getElementById("uploadModal").style.display = "block";
}

// Close the Modal
function closeModal() {
    document.getElementById("uploadModal").style.display = "none";
}

// Upload Photos Function (Add your upload logic here)
function uploadPhotos() {
    const files = document.getElementById("photoUpload").files;
    if (files.length > 0) {
        alert(`${files.length} file(s) selected for upload.`);
        // Your upload logic here
        closeModal(); // Close modal after uploading
    } else {
        alert("Please select a file to upload.");
    }
}

// Close modal if clicked outside of it
window.onclick = function (event) {
    const modal = document.getElementById("uploadModal");
    if (event.target == modal) {
        closeModal();
    }
};
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.baycolorlab.website', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devhub/baycolorlab.devhub.digtalsdesigns.com/resources/views/theme/baycolorlab/customize.blade.php ENDPATH**/ ?>