<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card no-export">
		    <div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Order List')); ?></span>
			</div>
			<div class="card-body">
				<table id="orders_table" class="table table-bordered">
					<thead>
					    <tr>
							<th><?php echo e(_lang('ID')); ?></th>
							<th><?php echo e(_lang('Customer Name')); ?></th>
							<th><?php echo e(_lang('Provided Images')); ?></th>
							<th><?php echo e(_lang('Order Summery')); ?></th>
							<th><?php echo e(_lang('Total')); ?></th>
							<th><?php echo e(_lang('Status')); ?></th>
							<th><?php echo e(_lang('Payment')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = App\PrintImages::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($loop->index+1); ?></td>
								<td><?php echo e($data->name); ?></td>
								<td>
									<ul>
										<?php $__currentLoopData = json_decode($data->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<li style="display: inline-block;width:10%;"> <img src="<?php echo e(asset('public/'.$dt)); ?>" alt="Uploaded Image" class="img-thumbnail thumbnail"></li>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</ul>
								</td>
								<td><?php echo e($data->order_info); ?></td>
								<td>$<?php echo e($data->total == '' ? '0' : $data->total); ?></td>
								<td><?php echo e($data->status); ?></td>
								<td><?php echo e($data->payment_status); ?></td>
								<td>
									<div class="dropdown">
										<button class="btn btn-light dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<?php echo e(_lang('Action')); ?>

										<i class="fas fa-angle-down"></i>
										</button>
										<form action="<?php echo e(action('OrderController@destroy', $data['id'])); ?>" method="post">
										  <?php echo e(csrf_field()); ?>

										  <input name="_method" type="hidden" value="DELETE">
										  
										  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
											  <a href="<?php echo e(action('OrderController@show', $data['id'])); ?>" class="dropdown-item dropdown-edit dropdown-edit"><i class="mdi mdi-pencil"></i> <?php echo e(_lang('View Order')); ?></a>
											  <button class="btn-remove dropdown-item" type="submit"><i class="mdi mdi-delete"></i> <?php echo e(_lang('Delete')); ?></button>
										  </div>
										</form>
									  </div>
								</td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('js-script'); ?>
<script>
    $('#orders_table').DataTable({
	
	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\baycolorlab\resources\views/backend/order/list.blade.php ENDPATH**/ ?>