

<?php $__env->startSection('content'); ?>
<!-- Slider Area -->
<section class="hero-slider">
	<!-- Single Slider -->
	<div class="single-slider" style="background-image: url('<?php echo e(get_option('hero_banner') != '' ? asset('public/uploads/media/'.get_option('hero_banner')) : asset('public/theme/default/images/slider-image2.jpg')); ?>')">
		<div class="container">
			<div class="row no-gutters">
				<div class="col-lg-9 offset-lg-3 col-12">
					<div class="text-inner">
						<div class="row">
							<div class="col-lg-7 col-12">
								<div class="hero-text">
									<h1><?php echo xss_clean(get_trans_option('hero_title')); ?></h1>
									<p><?php echo xss_clean(get_trans_option('hero_content')); ?></p>
									<?php if(get_trans_option('hero_button_text') != ''): ?>
										<div class="button">
											<a href="<?php echo e(get_trans_option('hero_button_link')); ?>" class="btn"><?php echo e(get_trans_option('hero_button_text')); ?></a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--/ End Single Slider -->
</section>
<!--/ End Slider Area -->

<?php if(get_option('enable_three_column_banner') == 1): ?>
	<!-- Start Small Banner  -->
	<section class="small-banner section">
		<div class="container-fluid">
			<div class="row">

				<!-- Single Banner  -->
				<div class="col-lg-4 col-md-6 col-12">
					<div class="single-banner">
						<img src="<?php echo e(get_option('three_column_1_background_image') != '' ? asset('public/uploads/media/'.get_option('three_column_1_background_image')) : asset('public/theme/default/images/no-banner.jpg')); ?>" alt="#">
						<div class="content">
							<p><?php echo e(get_trans_option('three_column_1_title')); ?></p>
							<h3><?php echo xss_clean(get_trans_option('three_column_1_sub_title')); ?></h3>
							<a href="<?php echo e(get_trans_option('three_column_1_button_link')); ?>"><?php echo e(get_trans_option('three_column_1_button_text')); ?></a>
						</div>
					</div>
				</div>
				<!-- /End Single Banner  -->


				<!-- Single Banner  -->
				<div class="col-lg-4 col-md-6 col-12">
					<div class="single-banner">
						<img src="<?php echo e(get_option('three_column_2_background_image') != '' ? asset('public/uploads/media/'.get_option('three_column_2_background_image')) : asset('public/theme/default/images/no-banner.jpg')); ?>" alt="#">
						<div class="content">
							<p><?php echo e(get_trans_option('three_column_2_title')); ?></p>
							<h3><?php echo xss_clean(get_trans_option('three_column_2_sub_title')); ?></h3>
							<a href="<?php echo e(get_trans_option('three_column_2_button_link')); ?>"><?php echo e(get_trans_option('three_column_2_button_text')); ?></a>
						</div>
					</div>
				</div>
				<!-- /End Single Banner  -->

				<!-- Single Banner  -->
				<div class="col-lg-4 col-12">
					<div class="single-banner tab-height">
						<img src="<?php echo e(get_option('three_column_3_background_image') != '' ? asset('public/uploads/media/'.get_option('three_column_3_background_image')) : asset('public/theme/default/images/no-banner.jpg')); ?>" alt="#">
						<div class="content">
							<p><?php echo e(get_trans_option('three_column_3_title')); ?></p>
							<h3><?php echo xss_clean(get_trans_option('three_column_3_sub_title')); ?></h3>
							<a href="<?php echo e(get_trans_option('three_column_3_button_link')); ?>"><?php echo e(get_trans_option('three_column_3_button_text')); ?></a>
						</div>
					</div>
				</div>
				<!-- /End Single Banner  -->

			</div>
		</div>
	</section>
	<!-- End Small Banner -->
<?php endif; ?>


<?php if(get_option('enable_trending_items') == 1): ?>
<!-- Start Product Area -->
<div class="product-area section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<h2><?php echo e(get_trans_option('trending_items_title')); ?></h2>
				</div>
			</div>
		</div>

		<?php $trending_categories = \App\Entity\Category\Category::whereIn('id', get_option('trending_categories'))->get(); ?>

		<div class="row">
			<div class="col-12">
				<div class="product-info">
					<div class="nav-main">
						<!-- Tab Nav -->
						<ul class="nav nav-tabs" id="myTab" role="tablist">
							<?php $__currentLoopData = $trending_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trending_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li class="nav-item"><a class="nav-link <?php echo e($loop->first ? 'active' : ''); ?>" data-toggle="tab" href="#trending_category<?php echo e($trending_category->id); ?>" role="tab"><?php echo e($trending_category->translation->name); ?></a></li>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</ul>
						<!--/ End Tab Nav -->
					</div>
					<div class="tab-content" id="myTabContent">
						<!-- Start Single Tab -->
						<?php $__currentLoopData = $trending_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trending_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="tab-pane fade <?php echo e($loop->first ? 'show active' : ''); ?>" id="trending_category<?php echo e($trending_category->id); ?>" role="tabpanel">
							<div class="tab-single">
								<div class="row">
									<?php $products = $trending_category->products; ?>
									<?php echo $__env->make('theme.default.components.product-grid',['class' => 'col-xl-3'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
								</div>
							</div>
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<!--/ End Single Tab -->
				
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- End Product Area -->
<?php endif; ?>

<?php if(get_option('enable_hot_items') == 1): ?>
<!-- Start Most Popular -->
<div class="product-area most-popular section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="section-title">
					<h2><?php echo e(get_trans_option('hot_items_title')); ?></h2>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-12">
				<div class="owl-carousel popular-slider">

					<?php $hot_items = \App\Entity\Product\Product::whereIn('id', get_option('hot_items',[]))->get(); ?>
					
					<?php $__currentLoopData = $hot_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hot_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<!-- Start Single Product -->
						<div class="single-product">
							<div class="product-img">
								<a href="<?php echo e(url('product/'.$hot_item->slug)); ?>">
									<img class="default-img" src="<?php echo e(asset('storage/app/'. $hot_item->image->file_path)); ?>" alt="<?php echo e($hot_item->translation->name); ?>">
									<?php if($hot_item->in_stock == 0): ?>
										<span class="out-of-stock"><?php echo e(_lang('Out Of Stock')); ?></span>
									<?php elseif($hot_item->featured_tag != NULL): ?>
										<span class="<?php echo e($hot_item->featured_tag); ?>"><?php echo e(_dlang(str_replace('_',' ',$hot_item->featured_tag))); ?></span>
									<?php endif; ?>
								</a>
								<div class="button-head">
									<div class="product-action">
										<a href="<?php echo e(url('product/'.$hot_item->slug)); ?>" title="<?php echo e(_lang('Quick View')); ?>" class="quick-shop">
											<i class=" ti-eye"></i><span><?php echo e(_lang('Quick Shop')); ?></span>
										</a>
										
										<a title="<?php echo e(_lang('Wishlist')); ?>" class="btn-wishlist" href="<?php echo e(wishlist_url($hot_item)); ?>"><i class=" ti-heart "></i><span><?php echo e(_lang('Add to Wishlist')); ?></span></a>
									</div>
									<div class="product-action-2">
										<?php if($hot_item->product_type != 'variable_product'): ?>
										    <?php if($hot_item->in_stock == 1): ?>
												<a title="Add to cart" class="add_to_cart" data-type="<?php echo e($hot_item->product_type); ?>" href="<?php echo e(url('add_to_cart/'.$hot_item->id)); ?>"><?php echo e(_lang('Add to cart')); ?></a>
											<?php else: ?>
												<a title="Add to cart" class="btn-link disabled" href="#"><?php echo e(_lang('Add to cart')); ?></a>
											<?php endif; ?>
										<?php else: ?>
											<a title="View Options" href="<?php echo e(url('product/'.$hot_item->slug)); ?>"><?php echo e(_lang('View Options')); ?></a>
										<?php endif; ?>
									</div>
								</div>
							</div>

							<div class="product-content">
								<h3><a href="<?php echo e(url('product/'.$hot_item->slug)); ?>"><?php echo e($hot_item->translation->name); ?></a></h3>
								
								<?php if($hot_item->product_type != 'variable_product'): ?>
									<div class="product-price">		
										<?php if($hot_item->special_price != '' || (int) $hot_item->special_price != 0 ): ?>
											<span class="text-danger">
												<s><?php echo xss_clean(show_price($hot_item->price)); ?></s>
											</span>
											<span class="text-success"><?php echo xss_clean(show_price($hot_item->special_price)); ?></span>
										<?php else: ?>
											<span><?php echo xss_clean(show_price($hot_item->price)); ?></span>	
										<?php endif; ?>
									</div>
								<?php else: ?>
									<div class="product-price">		
										<?php if($hot_item->variation_prices[0]->special_price != '' || (int) $hot_item->variation_prices[0]->special_price != 0 ): ?>
											<span class="text-danger">
												<s><?php echo xss_clean(show_price($hot_item->variation_prices[0]->price)); ?></s>
											</span>
											<span class="text-success">
												<?php echo xss_clean(show_price($hot_item->variation_prices[0]->special_price)); ?> 
												- 
												<?php echo xss_clean(show_price($hot_item->variation_prices[count($hot_item->variation_prices) - 1]->special_price)); ?>

											</span>
										<?php else: ?>
											<span>
												<?php echo xss_clean(show_price($hot_item->variation_prices[0]->price)); ?>

												- 
												<?php echo xss_clean(show_price($hot_item->variation_prices[count($hot_item->variation_prices) - 1]->price)); ?>

											</span>	
										<?php endif; ?>
									</div>
								<?php endif; ?>

								<div class="product-rating">
									<ul class="reviews">
										<?php echo xss_clean(show_rating($hot_item->reviews->avg('rating'))); ?>

									</ul>
								</div>

							</div>
						</div>
						<!-- End Single Product -->
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					
				</div>
			</div>
		</div>
	</div>
</div>
<!-- End Most Popular Area -->

<!-- Start Shop Home List  -->
<section class="shop-home-list section">
	<div class="container">
		<div class="row">
			<div class="col-lg-4 col-md-6 col-12">
				<div class="row">
					<div class="col-12">
						<div class="shop-section-title">
							<h1><?php echo e(get_trans_option('on_sale_items_title')); ?></h1>
						</div>
					</div>
				</div>

				<?php $on_sale_items = \App\Entity\Product\Product::whereIn('id', get_option('on_sale_items',[]))->get(); ?>

				<?php $__currentLoopData = $on_sale_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $on_sale_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<!-- Start Single List  -->
					<div class="single-list">
						<div class="row">
							<div class="col-lg-6 col-md-6 col-12">
								<div class="list-image overlay">
									<img src="<?php echo e(asset('storage/app/'. $on_sale_item->image->file_path)); ?>" alt="#">
									<a href="<?php echo e(url('product/'.$on_sale_item->slug)); ?>" class="buy"><i class="fa fa-shopping-bag"></i></a>
								</div>
							</div>
							<div class="col-lg-6 col-md-6 col-12 no-padding">
								<div class="content">
									<h4 class="title"><a href="<?php echo e(url('product/'.$on_sale_item->slug)); ?>"><?php echo e($on_sale_item->translation->name); ?></a></h4>
										
									<div class="product-price">		
										<?php if($on_sale_item->special_price != '' || (int) $on_sale_item->special_price != 0 ): ?>
											<p class="price with-discount"><?php echo xss_clean(show_price($on_sale_item->special_price)); ?></p>
										<?php else: ?>
											<p class="price with-discount"><?php echo xss_clean(show_price($on_sale_item->price)); ?></p>	
										<?php endif; ?>
									</div>

								</div>
							</div>
						</div>
					</div>
					<!-- End Single List  -->
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				
			</div>
			<div class="col-lg-4 col-md-6 col-12">
				<div class="row">
					<div class="col-12">
						<div class="shop-section-title">
							<h1><?php echo e(get_trans_option('best_seller_title')); ?></h1>
						</div>
					</div>
				</div>

				<?php 
					$best_seller_items = \App\Entity\Product\Product::whereIn('id', get_option('best_seller_items',[]))->get(); 
				?>

				<?php $__currentLoopData = $best_seller_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $best_seller_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<!-- Start Single List  -->
					<div class="single-list">
						<div class="row">
							<div class="col-lg-6 col-md-6 col-12">
								<div class="list-image overlay">
									<img src="<?php echo e(asset('storage/app/'. $best_seller_item->image->file_path)); ?>" alt="#">
									<a href="<?php echo e(url('product/'.$best_seller_item->slug)); ?>" class="buy"><i class="fa fa-shopping-bag"></i></a>
								</div>
							</div>
							<div class="col-lg-6 col-md-6 col-12 no-padding">
								<div class="content">
									<h4 class="title"><a href="<?php echo e(url('product/'.$best_seller_item->slug)); ?>"><?php echo e($best_seller_item->translation->name); ?></a></h4>
										
									<div class="product-price">		
										<?php if($best_seller_item->special_price != '' || (int) $best_seller_item->special_price != 0 ): ?>
											<p class="price with-discount"><?php echo xss_clean(show_price($best_seller_item->special_price)); ?></p>
										<?php else: ?>
											<p class="price with-discount"><?php echo xss_clean(show_price($best_seller_item->price)); ?></p>	
										<?php endif; ?>
									</div>

								</div>
							</div>
						</div>
					</div>
					<!-- End Single List  -->
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				
			</div>
			<div class="col-lg-4 col-md-6 col-12">
				<div class="row">
					<div class="col-12">
						<div class="shop-section-title">
							<h1><?php echo e(get_trans_option('top_views_title')); ?></h1>
						</div>
					</div>
				</div>

				<?php 
					$top_views_items = \App\Entity\Product\Product::whereIn('id', get_option('top_views_items',[]))->get(); 
				?>

				<?php $__currentLoopData = $top_views_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $top_views_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<!-- Start Single List  -->
					<div class="single-list">
						<div class="row">
							<div class="col-lg-6 col-md-6 col-12">
								<div class="list-image overlay">
									<img src="<?php echo e(asset('storage/app/'. $top_views_item->image->file_path)); ?>" alt="#">
									<a href="<?php echo e(url('product/'.$top_views_item->slug)); ?>" class="buy"><i class="fa fa-shopping-bag"></i></a>
								</div>
							</div>
							<div class="col-lg-6 col-md-6 col-12 no-padding">
								<div class="content">
									<h4 class="title"><a href="<?php echo e(url('product/'.$top_views_item->slug)); ?>"><?php echo e($top_views_item->translation->name); ?></a></h4>
										
									<div class="product-price">		
										<?php if($top_views_item->special_price != '' || (int) $top_views_item->special_price != 0 ): ?>
											<p class="price with-discount"><?php echo xss_clean(show_price($top_views_item->special_price)); ?></p>
										<?php else: ?>
											<p class="price with-discount"><?php echo xss_clean(show_price($top_views_item->price)); ?></p>	
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- End Single List  -->
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	
			</div>
		</div>
	</div>
</section>
<!-- End Shop Home List  -->
<?php endif; ?>

<?php echo $__env->make('theme.default.components.services', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script src="<?php echo e(asset('public/theme/default/js/cart.js?v=1.1')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.baycolorlab.website', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\baycolorlab\resources\views/theme/default/index.blade.php ENDPATH**/ ?>