<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Update User')); ?></span>
			</div>
			<div class="card-body">
				<form method="post" class="validate" autocomplete="off" action="<?php echo e(action('UserController@update', $id)); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>

					<input name="_method" type="hidden" value="PATCH">				
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
							   <label class="control-label"><?php echo e(_lang('Name')); ?></label>						
							   <input type="text" class="form-control" name="name" value="<?php echo e($user->name); ?>" required>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
							   <label class="control-label"><?php echo e(_lang('Email')); ?></label>						
							   <input type="text" class="form-control" name="email" value="<?php echo e($user->email); ?>" required>
							</div>
						</div>
						
						<div class="col-md-6">
							<div class="form-group">
							   <label class="control-label"><?php echo e(_lang('Password')); ?></label>						
							   <input type="password" class="form-control" name="password" value="">
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('User Type')); ?></label>						
								<select class="form-control select2 auto-select" data-selected="<?php echo e($user->user_type); ?>" name="user_type" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<option value="admin"><?php echo e(_lang('Admin')); ?></option>
									<option value="user"><?php echo e(_lang('User')); ?></option>
								</select>
							</div>
						</div>
						
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('User Role')); ?></label>						
								<select class="form-control select2 auto-select" data-selected="<?php echo e($user->role_id); ?>" name="role_id">
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php echo e(create_option('roles','id','name')); ?>

								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Status')); ?></label>						
								<select class="form-control select2 auto-select" data-selected="<?php echo e($user->status); ?>" name="status" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<option value="1"><?php echo e(_lang('Active')); ?></option>
									<option value="0"><?php echo e(_lang('In Active')); ?></option>
								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
							   <label class="control-label"><?php echo e(_lang('Profile Picture')); ?></label>						
							   <input type="file" class="form-control dropify" name="profile_picture">
							</div>
						</div>

						
						<div class="col-md-12">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><?php echo e(_lang('Update')); ?></button>
							</div>
						</div>	
					</div>	
				</form>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devhub/baycolorlab.devhub.digtalsdesigns.com/resources/views/backend/user/edit.blade.php ENDPATH**/ ?>