

<?php $__env->startSection('content'); ?>

	
<!-- Login Screen -->
<section id="auth"> 
	<div class="container">
		<div class="row">
			<div class="col-lg-6 offset-3">
				
				<?php if(\Session::has('success')): ?>
					<div class="alert alert-success mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span><?php echo xss_clean(session('success')); ?></span>
					</div>
				<?php endif; ?>

				<?php if(\Session::has('error')): ?>
					<div class="alert alert-danger mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span><?php echo xss_clean(session('error')); ?></span>
					</div>
				<?php endif; ?>


				<div class="login_register">
					<h3 class="section-heading"><?php echo e(_lang('Sign Up')); ?></h3>
					<form action="<?php echo e(url('/sign_up')); ?>" method="post">
						<?php echo csrf_field(); ?>
						<input type="text" name="name" value="<?php echo e(old('name')); ?>" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(_lang('Name')); ?>">
						
						<?php if($errors->has('name')): ?>
							<div class="invalid-feedback">
					          <?php echo e($errors->first('name')); ?>

					        </div>
				        <?php endif; ?>

						<input type="email" name="email" value="<?php echo e(old('email')); ?>" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(_lang('Email')); ?>">

						<?php if($errors->has('email')): ?>
							<div class="invalid-feedback">
					          <?php echo e($errors->first('email')); ?>

					        </div>
				        <?php endif; ?>

						<input type="text" name="phone"  value="<?php echo e(old('phone')); ?>" class="form-control <?php echo e($errors->has('phone') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(_lang('Phone')); ?>">

						<?php if($errors->has('phone')): ?>
							<div class="invalid-feedback">
					          <?php echo e($errors->first('phone')); ?>

					        </div>
				        <?php endif; ?>

						<input type="password" name="password" class="form-control <?php echo e($errors->has('password') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(_lang('Password')); ?>">

						<?php if($errors->has('password')): ?>
							<div class="invalid-feedback">
					          <?php echo e($errors->first('password')); ?>

					        </div>
				        <?php endif; ?>

						<input type="password" name="password_confirmation" class="form-control <?php echo e($errors->has('password_confirmation') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(_lang('Password Confrimation')); ?>">

						<?php if($errors->has('password_confirmation')): ?>
							<div class="invalid-feedback">
					          <?php echo e($errors->first('password_confirmation')); ?>

					        </div>
				        <?php endif; ?>

						<button type="submit" class="btn-login"><?php echo e(_lang('Sign Up')); ?></button>

						<div class="text-center">
							<a href="<?php echo e(url('sign_in')); ?>" class="right_link"><?php echo e(_lang('Already have an account?')); ?></a>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</section>
<!--/ End Login Screen -->
		

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script src="<?php echo e(asset('public/theme/default/js/cart.js?v=1.1')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.baycolorlab.website', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/protofy/baycolorlab.protofy.amgdigitalagency.com/resources/views/theme/baycolorlab/customer/sign_up.blade.php ENDPATH**/ ?>