<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-9">
		<div class="card">
		    <div class="card-header">
				<span class="panel-title"><?php echo e(_lang('View Order Details')); ?></span>
			</div>
			
			<div class="card-body">

			    <div class="receipt-content">
					<div class="row">
						<div class="col-md-12">
							<div class="invoice-wrapper">
								<h2>Order # <?php echo e($order->id); ?></h2>
								<div class="payment-details">
									<div class="row">
										<div class="col-sm-4">
											<span><?php echo e(_lang('Billing Details')); ?></span>
											<strong>
												<?php echo e($order->name); ?>

											</strong>
											<p>
												<?php echo e($order->email); ?>

												<?php echo e($order->address); ?><br>
												<?php echo e($order->city); ?><br>
												<?php echo e($order->state); ?>, <?php echo e($order->country); ?> <br>
												<?php echo e($order->postal_code); ?>

											</p>
										</div>

										<div class="col-sm-4">
											<span><?php echo e(_lang('Shipping Address')); ?></span>
											<p>
												<?php echo e($order->email); ?>

												<?php echo e($order->address); ?><br>
												<?php echo e($order->city); ?><br>
												<?php echo e($order->state); ?>, <?php echo e($order->country); ?> <br>
												<?php echo e($order->postal_code); ?>

											</p>
										</div>

										<div class="col-sm-4 text-right">
											<span><?php echo e(_lang('Payment To')); ?></span>
											<strong>
												<?php echo e(get_option('company_name')); ?>

											</strong>
											<p>
												<?php echo e(get_option('email')); ?><br>
												<?php echo e(get_option('phone')); ?><br>
												<?php echo xss_clean(get_option('address')); ?> <br>
											</p>
										</div>
									</div>
								</div>

								<div class="line-items">
									<table border="1" style="width:100%">
										<thead>
											<tr>
												<th>Type</th>
												<th>Qty</th>
												<th>Size</th>
												<th>Price</th>
											</tr>
										</thead>
										<tbody>
											<?php
												// Ensure the string is split into lines
												$items = preg_split('/\r\n|\r|\n/', $order->order_info); // Splitting by line breaks
											?>
									
											<?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<?php
													// Trim and check if the line is not empty
													$item = trim($item);
													
													// Using regular expression to extract type, quantity, size, and price
													// The format is assumed to be: Type x Qty (Size) - $Price
													preg_match('/^(.*?) x (\d+) \((.*?)\) - (\$\d+\.\d{2})$/', $item, $matches);
												?>
									
												<?php if($matches): ?>
													<tr style="border:1px solid #000;">
														<td style="border:1px solid #000;"><?php echo e($matches[1]); ?></td> <!-- Type -->
														<td style="border:1px solid #000;"><?php echo e($matches[2]); ?></td> <!-- Qty -->
														<td style="border:1px solid #000;"><?php echo e($matches[3]); ?></td> <!-- Size -->
														<td style="border:1px solid #000;"><?php echo e($matches[4]); ?></td> <!-- Price -->
													</tr>
												<?php else: ?>
													<!-- If no matches found, output raw data (for debugging purposes) -->
													<tr>
														<td colspan="4">Invalid Format: <?php echo e($item); ?></td>
													</tr>
												<?php endif; ?>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
									<div class="total text-right">
										<?php if($order->images != ''): ?>
										<div class="row">
											<?php $__currentLoopData = json_decode($order->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<div class="col-md-3">
													<img src="<?php echo e(asset('public/'.$image)); ?>" alt="Uploaded Image" class="img-thumbnail thumbnail">  
												</div>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</div>
										<a href="#" id="download-all"><i class="fa-solid fa-download"></i> Download All</a>
										<?php endif; ?>
											<h1 id="totall" style="background: #000;color: #fff;"><span id="total-text"><?php echo e(_lang('Total : ')); ?></span><span id="total-price">$<?php echo e($order->total); ?></span></h1>
									</div>

								</div>
							</div>
						</div>
					</div>
				</div>  

			</div>
	    </div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-script'); ?>
<script>
    $('#download-all').click(function() {
		console.log('looplapata')

        let images = <?php echo json_encode($order->images, 15, 512) ?>;
        images.forEach(function(image) {
            const link = document.createElement('a');
            link.href = '<?php echo e(asset('public/')); ?>' + '/' + image; // Full path to the image
            link.download = image.split('/').pop(); // Extract filename for download
            document.body.appendChild(link); // Append link to the body
            link.click(); // Trigger download
            document.body.removeChild(link); // Remove link after downloading
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\baycolorlab\resources\views/backend/order/view.blade.php ENDPATH**/ ?>