<?php $cart_items = Cart::getContent(); ?>

<a href="#" class="single-icon"><i class="ti-bag"></i> 
	<span class="total-count"><?php echo e(\Cart::getTotalQuantity()); ?></span>
</a>
<!-- Shopping Item -->
<div class="shopping-item">
	<div class="dropdown-cart-header">
		<span><?php echo e(\Cart::getTotalQuantity()); ?> <?php echo e(_lang('Items')); ?></span>
		<a href="<?php echo e(url('/cart')); ?>"><?php echo e(_lang('View Cart')); ?></a>
	</div>
	<ul class="shopping-list">
		<?php if(\Cart::isEmpty()): ?>
			<li class="text-center"><?php echo e(_lang('Cart is empty !')); ?></li>
		<?php endif; ?>

		<?php $__currentLoopData = $cart_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<li>
			<a href="<?php echo e(url('/remove_cart_item/'.$cart->id)); ?>" class="remove" title="<?php echo e(_lang('Remove this item')); ?>"><i class="fa fa-remove"></i></a>

			<a class="cart-img" href="<?php echo e(url('product/'.$cart->associatedModel->slug)); ?>"><img src="<?php echo e(asset('storage/app/'. $cart->associatedModel->image->file_path)); ?>" alt="#"></a>
			
			<h4>
				<a href="<?php echo e(url('product/'.$cart->associatedModel->slug)); ?>"><?php echo e($cart->associatedModel->translation->name); ?></a>
			</h4>

			<small>
				<?php $__currentLoopData = $cart->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<b><?php echo e($key); ?></b> : <?php echo e($val); ?><br> 
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</small>

			<p class="quantity"><?php echo e($cart->quantity); ?>x - <span class="amount"><?php echo xss_clean(show_price($cart->price)); ?></span></p>
		</li>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</ul>
	<div class="bottom">
		<div class="total">
			<span><?php echo e(_lang('Total')); ?></span>
			<span class="total-amount"><?php echo xss_clean(show_price(\Cart::getSubTotal())); ?></span>
		</div>
		<?php if(! Cart::isEmpty()): ?>
			<a href="<?php echo e(url('/checkout')); ?>" class="btn animate"><?php echo e(_lang('Checkout')); ?></a>
		<?php endif; ?>
	</div>
</div>
<!--/ End Shopping Item -->
<?php /**PATH C:\xampp\htdocs\baycolorlab\resources\views/theme/default/components/mini-cart.blade.php ENDPATH**/ ?>