

<?php $__env->startSection('content'); ?>
<style>
    .modal {
        display: none; /* Hidden by default */
        position: fixed;
        z-index: 1;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        background-color: #fff;
        margin: 15% auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
        max-width: 500px;
        text-align: center;
    }

    .close {
        color: #aaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
    }
</style>
<section class="customizer">
    <div class="row">
        <div class="col-md-12">
            <div class="customizer-top">
                <div class="my-photo-tab">
                    <a href="#" class="myphoto-btn"><i class="fa-regular fa-images"></i> MY PHOTOS</a>
                </div>
                <div class="upload-photo-tab">
                    <a class="upload-photo-btn" href="javascript:void(0);" onclick="openModal()">
                        <i class="fa-solid fa-cloud-arrow-up"></i> UPLOAD PHOTOS
                    </a>
                    <a href="<?php echo e(url('/computer-upload/'.$data->id)); ?>" class="refresh-btn"><i class="fa-solid fa-arrows-rotate"></i></a>
                    <p id="selected-count"><?php echo e(count(session('uploaded_images'))); ?> Selected</p>
                </div>
            </div>
        </div>
        <div id="uploadModal" class="modal">
            <div class="modal-content">
                <form action="<?php echo e(route('upload')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <span class="close" onclick="closeModal()">&times;</span>
                    <h2>Upload Photos</h2>
                    <input type="text" hidden name="order_id" value="<?php echo e($data->id); ?>"/>
                    <input type="file" id="MemberImage" name="images[]" class="dropify"data-height="220" multiple/>
                    <input type="submit" class="btn btn-primary" value="Upload">
                </form>
            </div>
        </div>
        <div class="col-md-2">
            <div class="number-pics">
                <div class="my-pics-butn">
                    <a class="my-bnt" href="#">My Photos <span id="photo-count"><?php echo e(count(session('uploaded_images'))); ?></span></a>
                    <!--<?php $__currentLoopData = session('uploaded_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                    <!--    <div class="image-item">-->
                    <!--        <p><?php echo e(str_replace("uploads/users/","", $image)); ?> <a href="#" class="remove-image" data-image="<?php echo e($image); ?>"><i class="fa-solid fa-xmark"></i></a></p>-->
                    <!--    </div>-->
                    <!--<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                </div>
                <!--<?php if(!Auth::check()): ?>-->
                <!--<div class="login-signup-btns">-->
                <!--    <a href="<?php echo e(url('sign_in')); ?>">Sign in</a>-->
                <!--    <a href="<?php echo e(url('sign_up')); ?>">Join</a>-->
                <!--</div>-->
                <!--<?php endif; ?>-->
            </div>
        </div>
        <div class="col-md-8">
            <div class="main-customiser">
                <div class="main-customiser-top">
                    <div class="options-left">
                        <a href="#"><i class="fa-regular fa-square-check"></i> Select All</a>
                        <a href="#"><i class="fa-regular fa-calendar-days"></i> Newest First</a>
                        <div class="pls-mkin">
                            <a href="#" id="increase-size"><i class="fa-solid fa-circle-plus"></i></a>
                            <a href="#" id="decrease-size"><i class="fa-solid fa-circle-minus"></i></a>
                            Thumb size
                        </div>
                    </div>
                    <div class="options-right"> 
                        <a href="#" id="download-all"><i class="fa-solid fa-download"></i> Download All</a>
                    </div>
                </div>
                <div class="img-wrap">
                    <?php $__currentLoopData = session('uploaded_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="image-item">
                            <p><?php echo e(str_replace("uploads/users/","", $image)); ?> <a href="#" class="remove-image" data-image="<?php echo e($image); ?>"><i class="fa-solid fa-xmark"></i></a></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="custom-img-set" id="image-container">
                    <?php if(session('uploaded_images')): ?>
                        <?php $__currentLoopData = session('uploaded_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-3 image-item">
                                <img src="<?php echo e(asset('public/'.$image)); ?>" alt="Uploaded Image" class="img-thumbnail thumbnail">  
                                <p><?php echo e(str_replace("uploads/users/","", $image)); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>No images uploaded.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-md-2 right-qan">
            <div class="right-side-quantiies">
                <div class="select-type">
                    <select name="image_selection" id="select_image">
                        <?php $__currentLoopData = session('uploaded_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option data-label="<?php echo e(str_replace('uploads/users/', '', $image)); ?>" value="<?php echo e(str_replace('uploads/users/', '', $image)); ?>">
                                <?php echo e(str_replace('uploads/users/', '', $image)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select name="select_type_of_paper" id="select_type_of_paper">
                        <?php $__currentLoopData = App\Paper::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($data3->id); ?>" data-label="<?php echo e($data3->name); ?>">
                                <?php echo e($data3->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="sizes-pic">
                    <?php $__currentLoopData = App\Sizes::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="size-one">
                            <label> <span class="size"><?php echo e($data2->size); ?> </span> <span class="price">$<?php echo e($data2->price); ?></span></label>
                            <input type="number" class="quantity" min="0" value="0" data-size="<?php echo e($data2->size); ?>" data-price="<?php echo e($data2->price); ?>">
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>


                

                <div class="check-ntn">
                    <form action="<?php echo e(route('add_to_cart')); ?>" id="checkout-form" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="text" hidden id="user_check" value="<?php echo e(Auth::check() ? 'true' : 'false'); ?>"/>
                        <input type="text" hidden name="order_id" id="order_id" value="<?php echo e($data->id); ?>"/>
                        <textarea hidden id="orderNote" name="order_info" placeholder="Your order details will appear here..."></textarea>
                        <textarea id="orderImages" hidden name="order_images" readonly><?php echo e(json_encode(session('uploaded_images'))); ?></textarea>
                        <input type="text" id="total" hidden name="total" value="">
                        <p>Cart Subtotal: <span id="subtotal">$0.00</span></p>
                        <input id="btnn" type="submit" value="Check Out">
                    </form>
                </div>
            </div>
        </div>

    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
    // Handle form submission
    document.getElementById('checkout-form').addEventListener('submit', function (e) {
        if (document.getElementById('user_check').value === 'false') {
            e.preventDefault();
            alert('Please log in first.');
        }
    });

    // Calculate subtotal
    const calculateSubtotal = () => {
        let subtotal = 0;
        const orderEntries = [];

        Object.entries(storedEntries).forEach(([key, details]) => {
            const [image, type] = key.split('|');
            const paperTypeName = selectType.querySelector(`[value="${details.type}"]`)?.getAttribute('data-label');

            Object.entries(details.quantities).forEach(([size, qty]) => {
                if (qty > 0) {
                    const price = details.prices[size];
                    const total = qty * price;
                    subtotal += total;
                    orderEntries.push(`${image} - ${paperTypeName} - ${size} x ${qty} - $${total.toFixed(2)}`);
                }
            });
        });

        subtotalElement.textContent = `$${subtotal.toFixed(2)}`;
        $('#total').val(subtotal.toFixed(2));
        orderNote.value = orderEntries.length ? orderEntries.join("\n") : "Your order details will appear here...";
    };

    // Store current details
    const storeCurrentDetails = () => {
        const key = `${selectImage.options[selectImage.selectedIndex]?.getAttribute('data-label')}|${selectType.value}`;
        storedEntries[key] = storedEntries[key] || { type: selectType.value, quantities: {}, prices: {} };

        document.querySelectorAll('.quantity').forEach(input => {
            const size = input.dataset.size;
            storedEntries[key].quantities[size] = parseInt(input.value) || 0;
            storedEntries[key].prices[size] = parseFloat(input.dataset.price);
        });

        calculateSubtotal();
    };

    // Reinitialize quantity event listeners after DOM changes
    const reinitializeQuantities = () => {
        document.querySelectorAll('.quantity').forEach(input => {
            input.removeEventListener('input', storeCurrentDetails);
            input.addEventListener('input', storeCurrentDetails);
        });
    };
    
    $('#select_image').change(function() {
        $('.quantity').val('0'); // Use .val() instead of .value
    });

    // Handle paper type change
    $('#select_type_of_paper').change(function () {
        const selectedPaperId = $(this).val();
        if (selectedPaperId) {
            $.get(`/getPaperData/${selectedPaperId}`, response => {
                const container = $('.sizes-pic').empty();
                response.forEach(({ size, price }) => {
                    container.append(`
                        <div class="size-one">
                            <label><span class="size">${size}</span> <span class="price">$${price}</span></label>
                            <input type="number" class="quantity" min="0" value="0" data-size="${size}" data-price="${price}">
                        </div>
                    `);
                });
                reinitializeQuantities();
                storeCurrentDetails();
            }).fail(err => console.error("AJAX error:", err));
        }
    });

    // Initialize on page load
    const selectType = document.getElementById('select_type_of_paper');
    const selectImage = document.getElementById('select_image');
    const subtotalElement = document.getElementById('subtotal');
    const orderNote = document.getElementById('orderNote');
    const storedEntries = {};
    storeCurrentDetails();
    reinitializeQuantities();
</script>

<script>
    // Handle image download
    document.getElementById('download-all').addEventListener('click', e => {
        e.preventDefault();
        const images = <?php echo json_encode(session('uploaded_images'), 15, 512) ?>;
        images.forEach(image => {
            const link = document.createElement('a');
            link.href = `<?php echo e(asset('public/')); ?>/${image}`;
            link.download = image.split('/').pop();
            link.click();
        });
    });

    // Adjust image sizes
    const adjustImageSize = scale => {
        document.querySelectorAll('.thumbnail').forEach(img => {
            img.style.width = img.offsetWidth * scale + 'px';
            img.style.height = img.offsetHeight * scale + 'px';
        });
    };
    document.getElementById('increase-size').addEventListener('click', e => { e.preventDefault(); adjustImageSize(1.2); });
    document.getElementById('decrease-size').addEventListener('click', e => { e.preventDefault(); adjustImageSize(0.8); });

    // Manage image uploads and display
    const updateImageDisplay = images => {
        const container = document.getElementById('image-container');
        container.innerHTML = images.length ? images.map(image => `
            <div class="col-md-3 image-item">
                <img src="<?php echo e(asset('public/')); ?>/${image}" alt="Uploaded Image" class="img-thumbnail thumbnail">
            </div>
        `).join('') : '<p>No images uploaded.</p>';
        document.getElementById('selected-count').textContent = `${images.length} Selected`;
        document.getElementById('orderImages').value = JSON.stringify(images);
    };

    const attachRemoveEvents = () => {
        document.querySelectorAll('.remove-image').forEach(link => {
            link.addEventListener('click', e => {
                e.preventDefault();
                fetch('/baycolorlab/remove-image', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                    body: JSON.stringify({ image: link.dataset.image }),
                }).then(res => res.json()).then(data => {
                    if (data.success) updateImageDisplay(data.images);
                    else alert('Error: ' + data.message);
                }).catch(console.error);
            });
        });
    };
    attachRemoveEvents();
</script>

<script>
    // Modal handling
    const modal = document.getElementById("uploadModal");
    window.onclick = e => { if (e.target === modal) closeModal(); };
    const closeModal = () => modal.style.display = "none";
    const openModal = () => modal.style.display = "block";
    const uploadPhotos = () => {
        const files = document.getElementById("photoUpload").files;
        alert(files.length ? `${files.length} file(s) selected.` : "Please select a file to upload.");
        if (files.length) closeModal();
    };
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.baycolorlab.website', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/protofy/baycolorlab.protofy.amgdigitalagency.com/resources/views/theme/baycolorlab/customize.blade.php ENDPATH**/ ?>