

<?php $__env->startSection('content'); ?>
<style>
.shop.checkout {
	padding: 0;
	background: #fff;
	padding-top: 20px;
	padding-bottom: 50px;
}
.shop.checkout .checkout-form {
	margin-top: 30px;
}
.shop.checkout .checkout-form h2 {
	font-size: 25px;
	color: #333;
	font-weight: 700;
	line-height: 27px;
}
.shop.checkout .checkout-form p {
	font-size: 16px;
	color: #333;
	font-weight: 400;
	margin-top: 12px;
	margin-bottom: 30px;
}

.shop.checkout .form-group {
	margin-bottom: 25px;
}
.shop.checkout .form-group label{
	color:#333;
	position:relative;
}
.shop.checkout .form-group label span {
	color: #ff2c18;
	display: inline-block;
	position: absolute;
	right: -12px;
	top: 4px;
	font-size: 16px;
}
.shop.checkout .form-group input {
	width: 100%;
	height: 45px;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}
.shop.checkout .form-group input[type=checkbox]{
	width: auto;
	height: auto;
}
.shop.checkout .form-group select {
	width: 100%;
	height: 45px;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}

.shop.checkout .form-group textarea {
	width: 100%;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}

.shop.checkout #payment-descriptions{
	width: 100%;
    min-height: 60px;
    line-height: 30px;
    border-radius: 0px;
    color: #333 !important;
    border: none;
    background: #F6F7FB;
    display: block;
    padding: 15px 20px;
    font-size: 14px;
}

.shop.checkout .nice-select {
	width: 100%;
	height: 45px;
	line-height: 50px;
	margin-bottom: 25px;
	background: #F6F7FB;
	border-radius: 0px;
	border:none;
}
.shop.checkout .nice-select .list {
	width: 100%;
	height: 300px;
	overflow: scroll;
}
.shop.checkout .nice-select .list li{}
.shop.checkout .nice-select .list li.option{
	color:#333;
}
.shop.checkout .nice-select .list li.option:hover{
	background:#F6F7FB;
	color:#333;
}
.shop.checkout .form .address input {
	margin-bottom: 15px;
}
.shop.checkout .form .address input:last-child{
	margin:0;
}
.shop.checkout .form .create-account {
	margin: 0;
}
.shop.checkout .form .create-account input {
	width: auto;
	display: inline-block;
	height: auto;
	border-radius: 100%;
	margin-right: 3px;
}
.shop.checkout .form .create-account label {
	display: inline-block;
	margin: 0;
}
.shop.checkout .order-details {
	margin-top: 30px;
	background: #fff;
	padding: 15px 0 30px 0;
	border: 1px solid #eee;
}
.shop.checkout .single-widget {
	margin-bottom: 30px;
}
.shop.checkout .single-widget:last-child{
	margin:0;
}
.shop.checkout .single-widget h2 {
	position:relative;
	font-size: 15px;
	font-weight: 600;
	padding: 10px 30px;
	line-height: 24px;
	text-transform: uppercase;
	color: #333;
	padding-bottom: 5px;
}
.shop.checkout .single-widget h2:before{
	position:absolute;
	content:"";
	left:30px;
	bottom:0;
	height:2px;
	width:50px;
	background:var(--primary-color);
}
.shop.checkout .single-widget .content ul{
	margin-top:30px;
}
.shop.checkout .single-widget .content ul li {
	display: block;
	padding: 0px 30px;
	font-size: 15px;
	font-weight: 400;
	color: #333;
	margin-bottom: 12px;
}
.shop.checkout .single-widget .content ul li span{
	display:inline-block;
	float:right;
}
.shop.checkout .single-widget .content ul li.last {
	padding-top: 12px;
	border-top: 1px solid #ebebeb;
	display: block;
	font-size: 15px;
	font-weight: 400;
	color: #333;
}

.shop.checkout .single-widget .content form {
	margin-top: 20px;
}

.shop.checkout .single-widget .content form input {
	width: 100%;
	display: inline-block;
	height: 48px;
	color: #333;
	padding: 0px 20px;
	border: 1px solid #333;
	box-shadow: 0px 0px 5px #0000000a;
}
.shop.checkout .single-widget .content form .btn {
    width: 100%;
    margin-top:5px;
}

.shop.checkout .single-widget .checkbox {
	text-align: left;
	margin: 0;
	padding: 0px 30px;
	margin-top:30px;
}
.shop.checkout .single-widget .checkbox label {
	color: #555555;
	position: relative;
	font-size: 14px;
	padding-left: 20px;
	margin-top: -5px;
	font-weight: 400;
	display: block;
	margin-bottom: 15px;
}
.shop.checkout .single-widget .checkbox label:last-child{
	margin-bottom:0;
}
.shop.checkout .single-widget .checkbox label:hover{
	cursor:pointer;
}
.shop.checkout .single-widget .checkbox label input{
	display:none;
}
.shop.checkout .single-widget .checkbox label::before {
	position: absolute;
	content: "";
	left: 0;
	top: 7px;
	width: 12px;
	height: 12px;
	line-height: 16px;
	border: 1px solid #666;
	border-radius: 100%;
}
.shop.checkout .single-widget .checkbox label::after {
	position: absolute;
	content: "";
	left: 0;
	top: 7px;
	width: 12px;
	height: 12px;
	line-height: 16px;
	border-radius: 100%;
	display:block;
	background:#666;
	transform:scale(0);
	-webkit-transition:all 0.4s ease;
	-moz-transition:all 0.4s ease;
	transition:all 0.4s ease;
}
.shop.checkout .single-widget .checkbox label.checked::after{
	opacity:1;
	visibility:visible;
	transform:scale(1);
}
.shop.checkout .single-widget.payement {
	padding: 0px 38px;
	text-align: center;
	margin-top: 30px;
}
.shop.checkout .single-widget.get-button {
	text-align: center;
	padding:0px 35px;
}
.shop.checkout .single-widget.get-button .btn {
	height: 46px;
	width: 100%;
	line-height: 30px;
	text-align: center;
	border-radius: 0;
	text-transform: uppercase;
	color: #fff;
    background-color: #000;
}
.custom-control-label {
    cursor: pointer;
}
h1#totall {
    margin-top: 3%;!;
    padding-bottom: 0%;
    background: #000;
    color: #fff;
}

span#total-price {
    float: right;
    padding-right: 3%;
}

span#total-text {
    padding-left: 3%;
}
</style>
<section class="shop checkout section">
	<div class="container">
		<div class="row"> 
            <div class="col-lg-4 col-12">
				<div class="order-details container-fluid">
					<div class="single-widget">
                        <h2 style="background: #000;color: #fff;"><?php echo e(_lang('Order Summery')); ?></h2>
                        <table border="1" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Qty</th>
                                    <th>Size</th>
                                    <th>Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    // Ensure the string is split into lines
                                    $items = preg_split('/\r\n|\r|\n/', $data->order_info); // Splitting by line breaks
                                ?>
                        
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        // Trim and check if the line is not empty
                                        $item = trim($item);
                                        
                                        // Using regular expression to extract type, quantity, size, and price
                                        // The format is assumed to be: Type x Qty (Size) - $Price
                                        preg_match('/^(.*?) x (\d+) \((.*?)\) - (\$\d+\.\d{2})$/', $item, $matches);
                                    ?>
                        
                                    <?php if($matches): ?>
                                        <tr style="border:1px solid #000;">
                                            <td style="border:1px solid #000;"><?php echo e($matches[1]); ?></td> <!-- Type -->
                                            <td style="border:1px solid #000;"><?php echo e($matches[2]); ?></td> <!-- Qty -->
                                            <td style="border:1px solid #000;"><?php echo e($matches[3]); ?></td> <!-- Size -->
                                            <td style="border:1px solid #000;"><?php echo e($matches[4]); ?></td> <!-- Price -->
                                        </tr>
                                    <?php else: ?>
                                        <!-- If no matches found, output raw data (for debugging purposes) -->
                                        <tr>
                                            <td colspan="4">Invalid Format: <?php echo e($item); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>  
						<h2 style="background: #000;color: #fff;margin-top: 3%;"><?php echo e(_lang('Order Content')); ?></h2>
						<div class="content" id="cart-contents">
                            <div class="row">
                                <?php $__currentLoopData = json_decode($data->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6">
                                    <img src="<?php echo e(asset('public/'.$image)); ?>" alt="Uploaded Image" class="img-thumbnail thumbnail">
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
						</div>
                        <h1 id="totall"><span id="total-text"><?php echo e(_lang('Total : ')); ?></span><span id="total-price">$<?php echo e($data->total); ?></span></h1>
					</div>
				</div>
			</div>
			<div class="col-lg-8 col-12">

				<?php if(\Session::has('success')): ?>
					<div class="alert alert-success mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span><?php echo xss_clean(session('success')); ?></span>
					</div>
				<?php endif; ?>

				<?php if(\Session::has('error')): ?>
					<div class="alert alert-danger mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span><?php echo xss_clean(session('error')); ?></span>
					</div>
				<?php endif; ?>

				<div class="checkout-form">

					<div class="alert-box"></div>

					<h2><?php echo e(_lang('Make Your Checkout Here')); ?></h2>
						<form id="checkout-form" method="post" action="<?php echo e(url('/make_order')); ?>">
							<?php echo csrf_field(); ?>
							<div class="row">
								<div class="col-12">
									<div class="form-group">
										<label><?php echo e(_lang('Name')); ?><span>*</span></label>
										<input type="text" name="order_id" hidden value="<?php echo e($data->id); ?>" required">
										<input type="text" name="name" placeholder="<?php echo e(_lang('Name')); ?>" value="<?php echo e(Auth::user()->name); ?>" required">
										
										<?php if($errors->has('name')): ?>
											<div class="invalid-feedback">
									          <?php echo e($errors->first('name')); ?>

									        </div>
								        <?php endif; ?>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label><?php echo e(_lang('Email Address')); ?><span>*</span></label>
										<input type="email" name="email" placeholder="<?php echo e(_lang('Email Address')); ?>" value="<?php echo e(Auth::user()->email); ?>" required>
										<?php if($errors->has('email')): ?>
											<div class="invalid-feedback">
									          <?php echo e($errors->first('email')); ?>

									        </div>
								        <?php endif; ?>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label><?php echo e(_lang('Phone Number')); ?><span>*</span></label>
										<input type="number" name="phone" placeholder="<?php echo e(_lang('Phone Number')); ?>" value="<?php echo e(Auth::user()->phone); ?>" required>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label><?php echo e(_lang('Country')); ?><span>*</span></label>
										<select name="country" class="customer-country" id="country" required>
											<?php $supported_countries = get_option('supported_countries'); ?>
							                <option value=""><?php echo e(_lang('Select Country')); ?></option>   	
											<?php if(!empty($supported_countries)): ?>
					                    	    <?php $__currentLoopData = get_all_country(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<?php if(in_array($country->name, $supported_countries)): ?>
															<option value="<?php echo e($country->sortname); ?>" data-id="<?php echo e($country->id); ?>" <?php echo e(old('country') == $country->sortname ? 'selected' : ''); ?>>
																<?php echo e($country->name); ?>

															</option>
														<?php endif; ?>
					                    	    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				                    	    <?php endif; ?>
										</select>
										<?php if($errors->has('country')): ?>
											<div class="invalid-feedback">
									          <?php echo e($errors->first('country')); ?>

									        </div>
								        <?php endif; ?>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label><?php echo e(_lang('State / Divition')); ?><span>*</span></label>
										<select name="state" class="select-state-no-auth" id="state" required>
											<option value=""><?php echo e(_lang('Select State')); ?></option>
                                            <option value="california">California</option>
										</select>
										<?php if($errors->has('state')): ?>
											<div class="invalid-feedback">
									          <?php echo e($errors->first('state')); ?>

									        </div>
								        <?php endif; ?>
									</div>
								</div>

								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label><?php echo e(_lang('City')); ?><span>*</span></label>
										<input type="text" name="city" placeholder="<?php echo e(_lang('City')); ?>" required="required">
										<?php if($errors->has('city')): ?>
											<div class="invalid-feedback">
									          <?php echo e($errors->first('city')); ?>

									        </div>
								        <?php endif; ?>
									</div>
								</div>

								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label><?php echo e(_lang('Postal Code')); ?><span>*</span></label>
										<input type="text" name="post_code" placeholder="<?php echo e(_lang('Postal Code')); ?>" required="required">
										<?php if($errors->has('post_code')): ?>
											<div class="invalid-feedback">
									          <?php echo e($errors->first('post_code')); ?>

									        </div>
								        <?php endif; ?>
									</div>
								</div>

								<div class="col-12">
									<div class="form-group">
										<label><?php echo e(_lang('Address')); ?><span>*</span></label>
										<input type="text" name="address" placeholder="<?php echo e(_lang('Address')); ?>" required>
										<?php if($errors->has('address')): ?>
											<div class="invalid-feedback">
									          <?php echo e($errors->first('address')); ?>

									        </div>
								        <?php endif; ?>
									</div>
								</div>				 
                                <div class="single-widget get-button">
                                    <input type="submit" class="btn" value="<?php echo e(_lang('Proceed to Payment')); ?>">
                                </div>
							</div>
						</form>
				</div>
			</div>
		</div>
	</div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.baycolorlab.website', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devhub/baycolorlab.devhub.digtalsdesigns.com/resources/views/theme/baycolorlab/checkout.blade.php ENDPATH**/ ?>