
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
		    <h5 class="card-header bg-primary text-white mt-0 panel-title"><?php echo e(_lang('Profile Settings')); ?></h5>
			<div class="card-body">
				<div class="row">
					<div class="col-md-6">
						<form action="<?php echo e(url('admin/profile/update')); ?>" autocomplete="off" class="form-horizontal form-groups-bordered validate" enctype="multipart/form-data" method="post">
							<?php echo csrf_field(); ?>
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Name')); ?></label>
								<input type="text" class="form-control" name="name" value="<?php echo e($profile->name); ?>" required>
							</div>
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Email')); ?></label>
								<input type="text" class="form-control" name="email" value="<?php echo e($profile->email); ?>" required>
							</div>

							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Image')); ?> (300 X 300)</label>
								<input type="file" class="form-control dropify" data-default-file="<?php echo e($profile->profile_picture != "" ? asset('public/uploads/profile/'.$profile->profile_picture) : ''); ?>" name="profile_picture" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
							</div>

							<div class="form-group">
								<button type="submit" class="btn btn-primary"><?php echo e(_lang('Update Profile')); ?></button>
							</div>
						</form>
					</div>	

                    <?php if(Auth::user()->user_type == 'user'): ?>
	                    <div class="col-md-6">
	                    	 <table class="table table-striped table-bordered">
						    	<tr>
						    		<td colspan="2" class="text-center"><b><?php echo e($profile->company->package->package_name.' '._lang('Package Details')); ?></b></td>
						    	</tr>
						    	<tr>
						    		<td><b><?php echo e(_lang('Feature')); ?></b></td>
						    		<td class="text-center"><b><?php echo e(_lang('Avaialble Limit')); ?></b></td>
						    	</tr>
						    	<tr>
						    		<td><?php echo e(_lang('Staff Limit')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->staff_limit); ?></td>
						    	</tr>
						    	<tr>
						    		<td><?php echo e(_lang('Contacts Limit')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->contacts_limit); ?></td>
						    	</tr>
						    	<tr>
						    		<td><?php echo e(_lang('Invoice Limit')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->invoice_limit); ?></td>
						    	</tr>
						    	<tr>
						    		<td><?php echo e(_lang('Quotation Limit')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->quotation_limit); ?></td>
						    	</tr>
						    	<tr>
						    		<td><?php echo e(_lang('Recurring Transaction')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->recurring_transaction); ?></td>
						    	</tr>
								<tr>
									<td><?php echo e(_lang('Inventory Module')); ?></td>
									<td class="text-center"><?php echo e($profile->company->inventory_module); ?></td>
								</tr>
						    	<tr>
						    		<td><?php echo e(_lang('Live Chat')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->live_chat); ?></td>
						    	</tr>
						    	<tr>
						    		<td><?php echo e(_lang('File Manager')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->file_manager); ?></td>
						    	</tr>
						    	<tr>
						    		<td><?php echo e(_lang('Online Payment')); ?></td>
						    		<td class="text-center"><?php echo e($profile->company->online_payment); ?></td>
						    	</tr>
						    </table>
	                    </div>
                    <?php endif; ?>


				</div>	
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devhub/baycolorlab.devhub.digtalsdesigns.com/resources/views/backend/profile/profile_edit.blade.php ENDPATH**/ ?>