<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="robots" content="noindex,nofollow">
	<title> Bay Color Lab</title>

	<link rel="icon" href="/favicon.ico" type="image/x-icon" />
	<link href="{{ asset('public/backend/plugins/dropify/css/dropify.min.css') }}" rel="stylesheet">
	<link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
	<link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
	<link href="{{ asset('public/theme/baycolor/css/slick.css') }}" rel="stylesheet">

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">

	<link rel="stylesheet" href="{{ asset('public/theme/baycolor/css/style.css') }}">
	<link rel="stylesheet" href="{{ asset('public/theme/baycolor/css/uploader-style.css') }}">
    <style>
        /*======================================
           Login & Register & My Account CSS
        ========================================*/
        .alert-success {
            color: #ffffff;
            background-color: #00b894;
            border-color: #00b894;
        }
        
        .alert-danger {
            color: #FFF;
            background-color: #ff4949;
            border-color: #ff4949;
        }
        
        .section{
        	padding-top: 80px;
        	padding-bottom: 50px;
        }
        
        .section-heading{
        	text-align: center;
        	font-weight: 600;
        	margin-bottom: 60px;
        	color: var(--primary-color);
        	position: relative;
        	line-height: 24px;
        }
        
        .section-heading::after{
        	content: '';
            width: 60px;
            height: 6px;
            background: var(--primary-color);
            border-radius: 10px;
            position: absolute;
            display: block;
            left: 0;
            right: 0;
            margin-left: auto;
            margin-right: auto;
            margin-top: 15px;
        }
        
        #auth{
        	padding: 60px 0px;
        }
        
        .login_register{
        	background: #ffffff;
            padding: 50px;
            box-shadow: 1px 3px 10px #d8d8d8;
        }
        
        .login_register .form-control {
        	height: auto;
            display: block;
            width: 100%;
           	padding: 15px;
            font-size: 1rem;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #CCC;
            border-radius: .25rem;
            margin-top: 15px;
            transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
        }
        
        .login_register .form-control:focus{
        	outline: none;
        	-webkit-box-shadow: none;
            box-shadow: none;
        	border: 1px solid #000;
        }
        
        .login_register .btn-login{
        	display: block;
            background: #FFF;
            padding: 18px 50px;
            border: 1px solid var(--primary-color);
            color: var(--primary-color);
        	transition: all 0.3s;
        	width: 100%;
        	margin-top: 30px;
        }
        .login_register .btn-login:hover{
            background: var(--primary-color);
            color: var(--primary-color);
        }
        
        .login_register .right_link{
        	color: var(--primary-color);
        	margin-top: 15px;
        	transition: all 0.3s;
        	display: inline-block;
        }
        
        .login_register .right_link:hover{
        	text-decoration: underline;
        }
        
        .create-account-link{
        	color: var(--primary-color);
        	display: inline-block;
        	margin-top: 15px;
        	transition: all 0.3s;
        }
        
        .create-account-link:hover{
        	color: var(--primary-color);
        	text-decoration: underline;
        }
        
        .customer_dashboard{
        	box-shadow: 0 0 4px 0 #e9e9e9;
        }
        
        .customer_dashboard{
        	box-shadow: 0 0 4px 0 #d0cfcf;
        }
        
        .customer_dashboard .nav-tabs li.nav-item a {
            text-align: left;
            padding: 12px 20px;
            border-radius: 0;
            border-bottom: 1px solid #efefef;
            color: #2b2f4c;
        }
        .customer_dashboard .nav-tabs li.nav-item a.active{
        	background: #1d2224;
        	color: #FFF;
        }
        .customer_dashboard .nav-tabs li.nav-item a i {
            margin-right: 8px;
            vertical-align: middle;
        }
        
        .dashboard_content .card-header {
            background-color: #1d2224;
            border-color: #1d2224;
            padding: 14px 20px;
        }
        
        .dashboard_content .card-header > h4 {
        	font-size: 16px;
        	color: #FFF;
        	font-weight: 400;
        	margin: 0;
        }
        
        .account_details .form-control {
        	height: auto;
            display: block;
            width: 100%;
           	padding: 15px;
            font-size: 1rem;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #CCC;
            border-radius: .25rem;
            margin-top: 15px;
            transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
        }
        
        .account_details .form-control:focus{
        	outline: none;
        	-webkit-box-shadow: none;
            box-shadow: none;
        	border: 1px solid #000;
        }
        
        .account_details .btn-login{
            background: #FFF;
            padding: 18px 50px;
            border: 1px solid #303952;
            color: #303952;
        	transition: all 0.3s;
        	margin-top: 30px;
        }
        .account_details .btn-login:hover{
            background: #303952;
            color: #FFF;
        }
        .btn-add-address{
        	color: #FFF !important;
        	padding: 6px 16px;
        	display: inline-block;
        	font-size: 14px;
        	border: 1px solid #FFF;
        	border-radius: 50px;
        }
        
        /*======================================
        	End Login CSS
        ========================================*/
    </style>
    <script>
        window.isLoggedIn = {{ Auth::check() ? 'true' : 'false' }};
    </script>
</head>

<body>
<header>
    <section class="top-header">
        <div class="container">
            <h2>Bay Color Photo Lab</h2>
            <a href="tel:(813)-870-0001">(813)-870-0001</a>
        </div>
    </section>
    <section class="main-nav">
        <div class="container">
            <div class="main-menu">
                <ul>
                    <li><a href="/bay-color">Upload Page</a></li>
                    <li><a href="https://baycolorlab.com/"> <i class="fa-solid fa-house"></i> Home</a></li>
                    <li><a href="https://baycolorlab.com/contact-us/">Contact Us</a></li>
                    <li><a href="https://baycolorlab.com/services-2/">Services</a></li>
                    <li><a href="https://baycolorlab.com/about-us/">About Us</a></li>
                    <li><a href="https://baycolorlab.com/preserve-your-memories/">Preserve your Memories</a></li>
                    @if(! Auth::check())
						<li><i class="ti-lock"></i><a href="{{ url('/sign_in') }}">{{ _lang('Login') }}</a></li>
                        <li><a href="https://baycolorlab.protofy.amgdigitalagency.com/sign_up">{{ _lang('Join') }}</a></li>
					@else
						<li><i class="ti-user"></i> <a href="{{ url('/my_account') }}">{{ _lang('My account') }}</a></li>
						<li><i class="ti-power-off"></i><a href="{{ url('/sign_out') }}">{{ _lang('Logout') }}</a></li>
                        <li><a href="https://baycolorlab.protofy.amgdigitalagency.com/sign_in">{{ _lang('Sign In') }}</a></li>
					@endif
                </ul>
            </div>
        </div>
    </section>
</header>
	@yield('content')
<footer>
    <section class="footer">
        <div class="container">
            <div class="fotter-main">
                <p>Bay Color Photo Lab copyright 2022</p>
                <p>A <a href="https://siteorigin.com/">SiteOrigin</a> Theme</p>
            </div>
        </div>
    </section>
</footer>

<script src="{{ asset('public/theme/baycolor/js/jquery.min.js') }}"></script>
<script  src="{{ asset('public/theme/baycolor/js/bootstrap.min.js') }}"></script>
<script  src="{{ asset('public/theme/baycolor/js/slick.js') }}"></script>
<script  src="{{ asset('public/theme/baycolor/js/wow.js') }}"></script>
<script  src="{{ asset('public/theme/baycolor/js/uploader.js') }}"></script>
<script  src="{{ asset('public/theme/baycolor/js/functions.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.js"
    integrity="sha512-WNZwVebQjhSxEzwbettGuQgWxbpYdoLf7mH+25A7sfQbbxKeS5SQ9QBf97zOY4nOlwtksgDA/czSTmfj4DUEiQ=="
    crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://unpkg.com/aos@next/dist/aos.js"></script>
<script src="https://unpkg.com/boxicons@2.1.4/dist/boxicons.js"></script>
<script src="{{ asset('public/backend/plugins/dropify/js/dropify.min.js') }}"></script>
<script src="{{ asset('public/backend/assets/js/scripts.js?v=1.2') }}"></script>
<script>
    AOS.init();
</script>
@yield('js-script')
</body>

</html>