@extends('theme.baycolorlab.website')

@section('content')
<script src="https://sandbox.web.squarecdn.com/v1/square.js"></script>
<style>
    .StripeElement {
    box-sizing: border-box;
    height: 40px;
    padding: 10px 12px;
    border: 1px solid transparent;
    border-radius: 4px;
    background-color: white;
    box-shadow: 0 1px 3px 0 #e6ebf1;
    -webkit-transition: box-shadow 150ms ease;
    transition: box-shadow 150ms ease;
    width: 100%;
    }

    .StripeElement--focus {
    box-shadow: 0 1px 3px 0 #cfd7df;
    }

    .StripeElement--invalid {
    border-color: #fa755a;
    }

    .StripeElement--webkit-autofill {
    background-color: #fefde5 !important;}
    
    .pay-now-btn{
        width: 100%;
        display: block;
        padding: 14px 15px;
        margin-top: 10px;
        background: #e91e63;
        color: #FFF;
    }

    .shop.checkout .single-widget .content form input.razorpay-payment-button {
        width: 100%;
        display: block;
        padding: 14px 15px;
        margin-top: 10px;
        background: #e91e63;
        color: #FFF;
        border: none;
    }

    .order-success{
        text-align: center;
        padding: 80px 20px;
    }

    .order-success > i{
        font-size: 60px;
        color: #1dd1a1;
    }

    .order-success > h2{
        padding: 15px 0px;
    }

    .order-success > p{
        color: #000;
        font-size: 16px;
    }

    .order-success > .btn-back-to-store{
        background: var(--primary-color);
        color: #FFF;
        padding: 12px 30px;
        display: inline-block;
        margin-top: 20px;
        border-radius: 2px;
    }
    .shop.checkout {
	padding: 0;
	background: #fff;
	padding-top: 20px;
	padding-bottom: 50px;
}
.shop.checkout .checkout-form {
	margin-top: 30px;
}
.shop.checkout .checkout-form h2 {
	font-size: 25px;
	color: #333;
	font-weight: 700;
	line-height: 27px;
}
.shop.checkout .checkout-form p {
	font-size: 16px;
	color: #333;
	font-weight: 400;
	margin-top: 12px;
	margin-bottom: 30px;
}

.shop.checkout .form-group {
	margin-bottom: 25px;
}
.shop.checkout .form-group label{
	color:#333;
	position:relative;
}
.shop.checkout .form-group label span {
	color: #ff2c18;
	display: inline-block;
	position: absolute;
	right: -12px;
	top: 4px;
	font-size: 16px;
}
.shop.checkout .form-group input {
	width: 100%;
	height: 45px;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}
.shop.checkout .form-group input[type=checkbox]{
	width: auto;
	height: auto;
}
.shop.checkout .form-group select {
	width: 100%;
	height: 45px;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}

.shop.checkout .form-group textarea {
	width: 100%;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}

.shop.checkout #payment-descriptions{
	width: 100%;
    min-height: 60px;
    line-height: 30px;
    border-radius: 0px;
    color: #333 !important;
    border: none;
    background: #F6F7FB;
    display: block;
    padding: 15px 20px;
    font-size: 14px;
}

.shop.checkout .nice-select {
	width: 100%;
	height: 45px;
	line-height: 50px;
	margin-bottom: 25px;
	background: #F6F7FB;
	border-radius: 0px;
	border:none;
}
.shop.checkout .nice-select .list {
	width: 100%;
	height: 300px;
	overflow: scroll;
}
.shop.checkout .nice-select .list li{}
.shop.checkout .nice-select .list li.option{
	color:#333;
}
.shop.checkout .nice-select .list li.option:hover{
	background:#F6F7FB;
	color:#333;
}
.shop.checkout .form .address input {
	margin-bottom: 15px;
}
.shop.checkout .form .address input:last-child{
	margin:0;
}
.shop.checkout .form .create-account {
	margin: 0;
}
.shop.checkout .form .create-account input {
	width: auto;
	display: inline-block;
	height: auto;
	border-radius: 100%;
	margin-right: 3px;
}
.shop.checkout .form .create-account label {
	display: inline-block;
	margin: 0;
}
.shop.checkout .order-details {
	margin-top: 30px;
	background: #fff;
	padding: 15px 0 30px 0;
	border: 1px solid #eee;
}
.shop.checkout .single-widget {
	margin-bottom: 30px;
}
.shop.checkout .single-widget:last-child{
	margin:0;
}
.shop.checkout .single-widget h2 {
	position:relative;
	font-size: 15px;
	font-weight: 600;
	padding: 10px 30px;
	line-height: 24px;
	text-transform: uppercase;
	color: #333;
	padding-bottom: 5px;
}
.shop.checkout .single-widget h2:before{
	position:absolute;
	content:"";
	left:30px;
	bottom:0;
	height:2px;
	width:50px;
	background:var(--primary-color);
}
.shop.checkout .single-widget .content ul{
	margin-top:30px;
}
.shop.checkout .single-widget .content ul li {
	display: block;
	padding: 0px 30px;
	font-size: 15px;
	font-weight: 400;
	color: #333;
	margin-bottom: 12px;
}
.shop.checkout .single-widget .content ul li span{
	display:inline-block;
	float:right;
}
.shop.checkout .single-widget .content ul li.last {
	padding-top: 12px;
	border-top: 1px solid #ebebeb;
	display: block;
	font-size: 15px;
	font-weight: 400;
	color: #333;
}

.shop.checkout .single-widget .content form {
	margin-top: 20px;
}

.shop.checkout .single-widget .content form input {
	width: 100%;
	display: inline-block;
	height: 48px;
	color: #333;
	padding: 0px 20px;
	border: 1px solid #333;
	box-shadow: 0px 0px 5px #0000000a;
}
.shop.checkout .single-widget .content form .btn {
    width: 100%;
    margin-top:5px;
}

.shop.checkout .single-widget .checkbox {
	text-align: left;
	margin: 0;
	padding: 0px 30px;
	margin-top:30px;
}
.shop.checkout .single-widget .checkbox label {
	color: #555555;
	position: relative;
	font-size: 14px;
	padding-left: 20px;
	margin-top: -5px;
	font-weight: 400;
	display: block;
	margin-bottom: 15px;
}
.shop.checkout .single-widget .checkbox label:last-child{
	margin-bottom:0;
}
.shop.checkout .single-widget .checkbox label:hover{
	cursor:pointer;
}
.shop.checkout .single-widget .checkbox label input{
	display:none;
}
.shop.checkout .single-widget .checkbox label::before {
	position: absolute;
	content: "";
	left: 0;
	top: 7px;
	width: 12px;
	height: 12px;
	line-height: 16px;
	border: 1px solid #666;
	border-radius: 100%;
}
.shop.checkout .single-widget .checkbox label::after {
	position: absolute;
	content: "";
	left: 0;
	top: 7px;
	width: 12px;
	height: 12px;
	line-height: 16px;
	border-radius: 100%;
	display:block;
	background:#666;
	transform:scale(0);
	-webkit-transition:all 0.4s ease;
	-moz-transition:all 0.4s ease;
	transition:all 0.4s ease;
}
.shop.checkout .single-widget .checkbox label.checked::after{
	opacity:1;
	visibility:visible;
	transform:scale(1);
}
.shop.checkout .single-widget.payement {
	padding: 0px 38px;
	text-align: center;
	margin-top: 30px;
}
.shop.checkout .single-widget.get-button {
	text-align: center;
	padding:0px 35px;
}
.shop.checkout .single-widget.get-button .btn {
	height: 46px;
	width: 100%;
	line-height: 30px;
	text-align: center;
	border-radius: 0;
	text-transform: uppercase;
	color: #fff;
    background: #000
}
.custom-control-label {
    cursor: pointer;
}
h1#totall {
    margin-top: 3%;!;
    padding-bottom: 0%;
    background: #000;
    color: #fff;
}

span#total-price {
    float: right;
    padding-right: 3%;
}

span#total-text {
    padding-left: 3%;
}
</style>
<section class="shop checkout section">
	<div class="container">
		<div class="row"> 
			<div class="col-12">
				@if(\Session::has('success'))
					<div class="alert alert-success mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span>{!! xss_clean(session('success')) !!}</span>
					</div>
				@endif

				@if(\Session::has('error'))
					<div class="alert alert-danger mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span>{!! xss_clean(session('error')) !!}</span>
					</div>
				@endif
			</div>

			<div class="col-lg-6 col-12">

				<div class="order-details">
					<div class="single-widget">
						<h2>{{ _lang('Payment Methods') }}</h2>
						<div class="content">
							<div class="payment-methods">
								<form id="payment-form">
                                    <div id="card-container"></div>
                                    <div id="cod-container">
									    <button id="card-button" style="background: #000;color: #fff;" class="btn" type="button">Confirm Order</button>
								    </div>
                                </form>
							</div>

						</div>
					</div>
				</div>

			</div>

			<div class="col-lg-6 col-12">
				<div class="order-details">
					
					<div class="single-widget">
                        <h2 style="background: #000;color: #fff;">{{ _lang('Order Summery') }}</h2>
                        <table border="1" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Size x Qty</th>
                                    <th>Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $items = preg_split('/\r\n|\r|\n/', $data->order_info); // Splitting by line breaks
                                @endphp
                        
                                @foreach ($items as $item)
                                    
                                    @php
                                        $item = explode('-', $item);
                                    @endphp
                                        <tr style="border:1px solid #000;">
                                            <td style="border:1px solid #000;">{{ $item[1] }}</td> <!-- Type -->
                                            <td style="border:1px solid #000;">{{ $item[2] }}</td> <!-- Qty -->
                                            <td style="border:1px solid #000;">{{ $item[3] }}</td> <!-- Price -->
                                        </tr>
                                @endforeach
                            </tbody>
                        </table>  
						
                        <h1 id="totall"><span id="total-text">{{ _lang('Total : ') }}</span><span id="total-price">${{ $data->total }}</span></h1>
					</div>

					
					<div class="single-widget get-button">
						<div class="content">
							<div class="button" id="payment-button">
								<div id="stripe-container" class="d-none">
									@include('theme.baycolorlab.gateways.stripe')
								</div>

								<div id="cod-container" class="d-none">
									<a href="{{ url('gateway/confirm_order/cod/'.encrypt($data->id)) }}" id="confirm_order" class="btn">{{ _lang('Confirm Order') }}</a>
								</div>
							</div>
						</div>
					</div>
					
				</div>
			</div>
		</div>
	</div>
</section>
@endsection

@section('js-script')
<script type="text/javascript">
            document.addEventListener("DOMContentLoaded", async function () {
                const payments = Square.payments("{{ env('SQUARE_APPLICATION_ID') }}", "{{ env('SQUARE_LOCATION_ID') }}");
        
                const card = await payments.card();
                await card.attach("#card-container");
        
                document.getElementById("card-button").addEventListener("click", async (event) => {
                    event.preventDefault();
                    const tokenResult = await card.tokenize();
                    if (tokenResult.status === "OK") {
                        // Send tokenResult.token to your server for further processing
                        const response = await fetch('https://baycolorlab.protofy.amgdigitalagency.com/gateway/square-payment/{{ $data->id }}/{{ $data->total }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({ token: tokenResult.token })
                        });
						const result = await response.json();
						if (result.status === 'success') {
							console.log('Success Ho Gaya Hy')
							window.location.href = result.redirect_url;
						} else {
							alert('Payment failed. Please try again.');
						}
                    } else {
                        alert('Payment tokenization failed. Try again.');
                    }
                });
            });
        </script>
<script src="{{ asset('public/theme/default/js/checkout.js') }}"></script>
@endsection