@extends('theme.baycolorlab.website')

@section('content')
<section class="three-device">
    <div class="container">
        <h2>Where would you like to upload photos from?</h2>
        <div class="row justify-content-center">
            <div class="col-md-3">
                <div class="computer-dev">
                    <a onclick="handleComputerUpload()">
                        <h4>My Computer</h4>
                        <img src="{{ asset('public/theme/baycolor/images/computer.png') }}" alt="">
                        <p>Upload photos from your Computer</p>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="mobile-dev">
                    <!--<a href="{{ url('/computer-upload') }}">-->
                    <a onclick="handleComputerUpload()">
                        <h4>Mobile Device</h4>
                        <img src="{{ asset('public/theme/baycolor/images/mobile.png') }}" alt="">
                        <p>Upload photos from your phone or tablet.</p>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="cloud-dev">
                    <!--<a href="{{ url('/cloud-upload') }}">-->
                    <a onclick="handleComputerUpload()">
                        <h4>Cloud Storage</h4>
                        <img src="{{ asset('public/theme/baycolor/images/cloud.png') }}" alt="">
                        <p>Access photos from Facebook, Instagram, Google, and more.</p>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function handleComputerUpload(id = null) {
        // Check login status on the client side
        if (!window.isLoggedIn) {
            // Show SweetAlert Toast immediately
            Swal.fire({
                icon: 'warning',
                title: 'Login Required',
                text: 'Please login first!',
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000
            });
            return; // Stop execution here
        }

        window.location.href = "{{ url('/computer-upload') }}";
    }
</script>
@endsection

@section('js-script')

@endsection