@extends('theme.baycolorlab.website')

@section('content')
<style>
.shop.checkout {
	padding: 0;
	background: #fff;
	padding-top: 20px;
	padding-bottom: 50px;
}
.shop.checkout .checkout-form {
	margin-top: 30px;
}
.shop.checkout .checkout-form h2 {
	font-size: 25px;
	color: #333;
	font-weight: 700;
	line-height: 27px;
}
.shop.checkout .checkout-form p {
	font-size: 16px;
	color: #333;
	font-weight: 400;
	margin-top: 12px;
	margin-bottom: 30px;
}

.shop.checkout .form-group {
	margin-bottom: 25px;
}
.shop.checkout .form-group label{
	color:#333;
	position:relative;
}
.shop.checkout .form-group label span {
	color: #ff2c18;
	display: inline-block;
	position: absolute;
	right: -12px;
	top: 4px;
	font-size: 16px;
}
.shop.checkout .form-group input {
	width: 100%;
	height: 45px;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}
.shop.checkout .form-group input[type=checkbox]{
	width: auto;
	height: auto;
}
.shop.checkout .form-group select {
	width: 100%;
	height: 45px;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}

.shop.checkout .form-group textarea {
	width: 100%;
	line-height: 50px;
	padding: 0 20px;
	border-radius: 3px;
	border-radius: 0px;
	color: #333 !important;
	border: none;
	background: #F6F7FB;
}

.shop.checkout #payment-descriptions{
	width: 100%;
    min-height: 60px;
    line-height: 30px;
    border-radius: 0px;
    color: #333 !important;
    border: none;
    background: #F6F7FB;
    display: block;
    padding: 15px 20px;
    font-size: 14px;
}

.shop.checkout .nice-select {
	width: 100%;
	height: 45px;
	line-height: 50px;
	margin-bottom: 25px;
	background: #F6F7FB;
	border-radius: 0px;
	border:none;
}
.shop.checkout .nice-select .list {
	width: 100%;
	height: 300px;
	overflow: scroll;
}
.shop.checkout .nice-select .list li{}
.shop.checkout .nice-select .list li.option{
	color:#333;
}
.shop.checkout .nice-select .list li.option:hover{
	background:#F6F7FB;
	color:#333;
}
.shop.checkout .form .address input {
	margin-bottom: 15px;
}
.shop.checkout .form .address input:last-child{
	margin:0;
}
.shop.checkout .form .create-account {
	margin: 0;
}
.shop.checkout .form .create-account input {
	width: auto;
	display: inline-block;
	height: auto;
	border-radius: 100%;
	margin-right: 3px;
}
.shop.checkout .form .create-account label {
	display: inline-block;
	margin: 0;
}
.shop.checkout .order-details {
	margin-top: 30px;
	background: #fff;
	padding: 15px 0 30px 0;
	border: 1px solid #eee;
}
.shop.checkout .single-widget {
	margin-bottom: 30px;
}
.shop.checkout .single-widget:last-child{
	margin:0;
}
.shop.checkout .single-widget h2 {
	position:relative;
	font-size: 15px;
	font-weight: 600;
	padding: 10px 30px;
	line-height: 24px;
	text-transform: uppercase;
	color: #333;
	padding-bottom: 5px;
}
.shop.checkout .single-widget h2:before{
	position:absolute;
	content:"";
	left:30px;
	bottom:0;
	height:2px;
	width:50px;
	background:var(--primary-color);
}
.shop.checkout .single-widget .content ul{
	margin-top:30px;
}
.shop.checkout .single-widget .content ul li {
	display: block;
	padding: 0px 30px;
	font-size: 15px;
	font-weight: 400;
	color: #333;
	margin-bottom: 12px;
}
.shop.checkout .single-widget .content ul li span{
	display:inline-block;
	float:right;
}
.shop.checkout .single-widget .content ul li.last {
	padding-top: 12px;
	border-top: 1px solid #ebebeb;
	display: block;
	font-size: 15px;
	font-weight: 400;
	color: #333;
}

.shop.checkout .single-widget .content form {
	margin-top: 20px;
}

.shop.checkout .single-widget .content form input {
	width: 100%;
	display: inline-block;
	height: 48px;
	color: #333;
	padding: 0px 20px;
	border: 1px solid #333;
	box-shadow: 0px 0px 5px #0000000a;
}
.shop.checkout .single-widget .content form .btn {
    width: 100%;
    margin-top:5px;
}

.shop.checkout .single-widget .checkbox {
	text-align: left;
	margin: 0;
	padding: 0px 30px;
	margin-top:30px;
}
.shop.checkout .single-widget .checkbox label {
	color: #555555;
	position: relative;
	font-size: 14px;
	padding-left: 20px;
	margin-top: -5px;
	font-weight: 400;
	display: block;
	margin-bottom: 15px;
}
.shop.checkout .single-widget .checkbox label:last-child{
	margin-bottom:0;
}
.shop.checkout .single-widget .checkbox label:hover{
	cursor:pointer;
}
.shop.checkout .single-widget .checkbox label input{
	display:none;
}
.shop.checkout .single-widget .checkbox label::before {
	position: absolute;
	content: "";
	left: 0;
	top: 7px;
	width: 12px;
	height: 12px;
	line-height: 16px;
	border: 1px solid #666;
	border-radius: 100%;
}
.shop.checkout .single-widget .checkbox label::after {
	position: absolute;
	content: "";
	left: 0;
	top: 7px;
	width: 12px;
	height: 12px;
	line-height: 16px;
	border-radius: 100%;
	display:block;
	background:#666;
	transform:scale(0);
	-webkit-transition:all 0.4s ease;
	-moz-transition:all 0.4s ease;
	transition:all 0.4s ease;
}
.shop.checkout .single-widget .checkbox label.checked::after{
	opacity:1;
	visibility:visible;
	transform:scale(1);
}
.shop.checkout .single-widget.payement {
	padding: 0px 38px;
	text-align: center;
	margin-top: 30px;
}
.shop.checkout .single-widget.get-button {
	text-align: center;
	padding:0px 35px;
}
.shop.checkout .single-widget.get-button .btn {
	height: 46px;
	width: 100%;
	line-height: 30px;
	text-align: center;
	border-radius: 0;
	text-transform: uppercase;
	color: #fff;
    background-color: #000;
}
.custom-control-label {
    cursor: pointer;
}
h1#totall {
    margin-top: 3%;!;
    padding-bottom: 0%;
    background: #000;
    color: #fff;
}

span#total-price {
    float: right;
    padding-right: 3%;
}

span#total-text {
    padding-left: 3%;
}
</style>
<section class="shop checkout section">
	<div class="container">
		<div class="row"> 
            <div class="col-lg-4 col-12">
				<div class="order-details container-fluid">
					<div class="single-widget">
                        <h2 style="background: #000;color: #fff;">{{ _lang('Order Summery') }}</h2>
                        <table border="1" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Size x Qty</th>
                                    <th>Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $items = preg_split('/\r\n|\r|\n/', $data->order_info); // Splitting by line breaks
                                @endphp
                        
                                @foreach ($items as $item)
                                    
                                    @php
                                        $item = explode('-', $item);
                                    @endphp
                                        <tr style="border:1px solid #000;">
                                            <td style="border:1px solid #000;">{{ $item[1] }}</td> <!-- Type -->
                                            <td style="border:1px solid #000;">{{ $item[2] }}</td> <!-- Qty -->
                                            <td style="border:1px solid #000;">{{ $item[3] }}</td> <!-- Price -->
                                        </tr>
                                @endforeach
                            </tbody>
                        </table>  
						<h2 style="background: #000;color: #fff;margin-top: 3%;">{{ _lang('Order Content') }}</h2>
						<div class="content" id="cart-contents">
                            <div class="row">
                                @foreach(json_decode($data->images) as $image)
                                <div class="col-md-6">
                                    <img src="{{ asset('public/'.$image) }}" alt="Uploaded Image" class="img-thumbnail thumbnail">
                                </div>
                                @endforeach
                            </div>
						</div>
                        <h1><span id="total-text">{{ _lang('Tax : ') }}</span><span id="total-price">%6.5</span></h1>
                        <h1 id="totall"><span id="total-text">{{ _lang('Total : ') }}</span><span id="total-price">${{ number_format($data->total * 1.065, 2) }}</span></h1>
					</div>
				</div>
			</div>
			<div class="col-lg-8 col-12">

				@if(\Session::has('success'))
					<div class="alert alert-success mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span>{!! xss_clean(session('success')) !!}</span>
					</div>
				@endif

				@if(\Session::has('error'))
					<div class="alert alert-danger mt-4">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<span>{!! xss_clean(session('error')) !!}</span>
					</div>
				@endif

				<div class="checkout-form">

					<div class="alert-box"></div>

					<h2>{{ _lang('Make Your Checkout Here') }}</h2>
						<form id="checkout-form" method="post" action="{{ url('/make_order') }}">
							@csrf
							<div class="row">
								<div class="col-12">
									<div class="form-group">
										<label>{{ _lang('Name') }}<span>*</span></label>
										<input type="text" name="order_id" hidden value="{{ $data->id }}" required">
										<input type="text" name="name" placeholder="{{ _lang('Name') }}" value="{{ Auth::user()->name }}" required">
										
										@if($errors->has('name'))
											<div class="invalid-feedback">
									          {{ $errors->first('name') }}
									        </div>
								        @endif
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label>{{ _lang('Email Address') }}<span>*</span></label>
										<input type="email" name="email" placeholder="{{ _lang('Email Address') }}" value="{{ Auth::user()->email }}" required>
										@if($errors->has('email'))
											<div class="invalid-feedback">
									          {{ $errors->first('email') }}
									        </div>
								        @endif
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label>{{ _lang('Phone Number') }}<span>*</span></label>
										<input type="number" name="phone" placeholder="{{ _lang('Phone Number') }}" value="{{ Auth::user()->phone }}" required>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label>{{ _lang('Country') }}<span>*</span></label>
										<select name="country" class="customer-country" id="country" required>
											@php $supported_countries = get_option('supported_countries'); @endphp
							                <option value="">{{ _lang('Select Country') }}</option>   	
											@if(!empty($supported_countries))
					                    	    @foreach(get_all_country() as $country)
														@if(in_array($country->name, $supported_countries))
															<option value="{{ $country->sortname }}" data-id="{{ $country->id }}" {{ old('country') == $country->sortname ? 'selected' : '' }}>
																{{ $country->name }}
															</option>
														@endif
					                    	    @endforeach
				                    	    @endif
										</select>
										@if($errors->has('country'))
											<div class="invalid-feedback">
									          {{ $errors->first('country') }}
									        </div>
								        @endif
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label>{{ _lang('State / Divition') }}<span>*</span></label>
										<select name="state" class="select-state-no-auth" id="state" required>
											 <option value="">{{ _lang('Select State') }}</option>
                                            <option value="alabama">Alabama</option>
                                            <option value="alaska">Alaska</option>
                                            <option value="arizona">Arizona</option>
                                            <option value="arkansas">Arkansas</option>
                                            <option value="california">California</option>
                                            <option value="colorado">Colorado</option>
                                            <option value="connecticut">Connecticut</option>
                                            <option value="delaware">Delaware</option>
                                            <option value="florida">Florida</option>
                                            <option value="georgia">Georgia</option>
                                            <option value="hawaii">Hawaii</option>
                                            <option value="idaho">Idaho</option>
                                            <option value="illinois">Illinois</option>
                                            <option value="indiana">Indiana</option>
                                            <option value="iowa">Iowa</option>
                                            <option value="kansas">Kansas</option>
                                            <option value="kentucky">Kentucky</option>
                                            <option value="louisiana">Louisiana</option>
                                            <option value="maine">Maine</option>
                                            <option value="maryland">Maryland</option>
                                            <option value="massachusetts">Massachusetts</option>
                                            <option value="michigan">Michigan</option>
                                            <option value="minnesota">Minnesota</option>
                                            <option value="mississippi">Mississippi</option>
                                            <option value="missouri">Missouri</option>
                                            <option value="montana">Montana</option>
                                            <option value="nebraska">Nebraska</option>
                                            <option value="nevada">Nevada</option>
                                            <option value="new-hampshire">New Hampshire</option>
                                            <option value="new-jersey">New Jersey</option>
                                            <option value="new-mexico">New Mexico</option>
                                            <option value="new-york">New York</option>
                                            <option value="north-carolina">North Carolina</option>
                                            <option value="north-dakota">North Dakota</option>
                                            <option value="ohio">Ohio</option>
                                            <option value="oklahoma">Oklahoma</option>
                                            <option value="oregon">Oregon</option>
                                            <option value="pennsylvania">Pennsylvania</option>
                                            <option value="rhode-island">Rhode Island</option>
                                            <option value="south-carolina">South Carolina</option>
                                            <option value="south-dakota">South Dakota</option>
                                            <option value="tennessee">Tennessee</option>
                                            <option value="texas">Texas</option>
                                            <option value="utah">Utah</option>
                                            <option value="vermont">Vermont</option>
                                            <option value="virginia">Virginia</option>
                                            <option value="washington">Washington</option>
                                            <option value="west-virginia">West Virginia</option>
                                            <option value="wisconsin">Wisconsin</option>
                                            <option value="wyoming">Wyoming</option>
										</select>
										@if($errors->has('state'))
											<div class="invalid-feedback">
									          {{ $errors->first('state') }}
									        </div>
								        @endif
									</div>
								</div>

								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label>{{ _lang('City') }}<span>*</span></label>
										<input type="text" name="city" placeholder="{{ _lang('City') }}" required="required">
										@if($errors->has('city'))
											<div class="invalid-feedback">
									          {{ $errors->first('city') }}
									        </div>
								        @endif
									</div>
								</div>

								<div class="col-lg-6 col-md-6 col-12">
									<div class="form-group">
										<label>{{ _lang('Postal Code') }}<span>*</span></label>
										<input type="text" name="post_code" placeholder="{{ _lang('Postal Code') }}" required="required">
										@if($errors->has('post_code'))
											<div class="invalid-feedback">
									          {{ $errors->first('post_code') }}
									        </div>
								        @endif
									</div>
								</div>

								<div class="col-12">
									<div class="form-group">
										<label>{{ _lang('Address') }}<span>*</span></label>
										<input type="text" name="address" placeholder="{{ _lang('Address') }}" required>
										@if($errors->has('address'))
											<div class="invalid-feedback">
									          {{ $errors->first('address') }}
									        </div>
								        @endif
									</div>
								</div>				 
                                <div class="single-widget get-button">
                                    <input type="submit" class="btn" value="{{ _lang('Proceed to Payment') }}">
                                </div>
							</div>
						</form>
				</div>
			</div>
		</div>
	</div>
</section>
@endsection

@section('js-script')

@endsection