<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta content="<?php echo isset($description) ? $description : '';  ?>" name="description">
	<title> <?php echo isset($title) ? $title : 'Car Match Rental';  ?> </title>

	<?php
	if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
		$url_p = "https://";
	} else {
		$url_p = "https://";
	}
	$url_p .= $_SERVER['HTTP_HOST'];
	$url_p .= $_SERVER['REQUEST_URI'];
	$url_p = str_replace(".php", "", $url_p);
	$url_p = str_replace("index", "", $url_p);
	$url_p = preg_replace('/\?.*/', '', $url_p);
	$url_p = str_replace("//", "/", $url_p);
	$url_p = str_replace("https:/", "https://", $url_p);
	?>

	<meta property="og:locale" content="en_US" />
	<meta property="fb:app_id" content="" />
	<meta property="og:type" content="article" />
	<meta property="og:title" content="" />
	<meta property="og:description" content="" />
	<meta property="og:url" content="<?= $url_p; ?>" />
	<meta property="og:site_name" content="" />
	<meta property="og:image" content="" />
	<meta property="og:image:secure_url" content="" />
	<meta property="og:image:width" content="1024" />
	<meta property="og:image:height" content="576" />
	<meta name="twitter:card" content="summary" />
	<meta name="twitter:site" content="" />
	<meta name="twitter:title" content="" />
	<meta name="twitter:description" content="" />
	<meta name="twitter:image" content="" />
	<meta name="twitter:image:alt" content="" />

	<link rel="icon" href="/favicon.ico" type="image/x-icon" />
	<!-- Box Icon Start -->
	<link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
	<link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
	<link href="css/slick.css" rel="stylesheet">


	<!-- LIBRARIES -->

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">

	<!-- CUSTOM STYLE -->
	<link rel="stylesheet" href="css/style.css">

</head>

<body>
<header>
    <section class="top-header">
        <div class="container">
            <h2>Bay Color Photo Lab</h2>
            <a href="tel:(813)-870-0001">(813)-870-0001</a>
        </div>
    </section>
    <section class="main-nav">
        <div class="container">
            <div class="main-menu">
                <ul>
                    <li><a href="/bay-color">Upload Page</a></li>
                    <li><a href="https://baycolorlab.com/"> <i class="fa-solid fa-house"></i> Home</a></li>
                    <li><a href="https://baycolorlab.com/contact-us/">Contact Us</a></li>
                    <li><a href="https://baycolorlab.com/services-2/">Services</a></li>
                    <li><a href="https://baycolorlab.com/about-us/">About Us</a></li>
                    <li><a href="https://baycolorlab.com/preserve-your-memories/">Preserve your Memories</a></li>
                </ul>
            </div>
        </div>
    </section>
</header>
<section class="three-device">
    <div class="container">
        <h2>Where would you like to upload photos from?</h2>
        <div class="row justify-content-center">
            <div class="col-md-3">
                <div class="computer-dev">
                    <a href="upload-computer.php">
                        <h4>My Computer</h4>
                        <img src="images/computer.png" alt="">
                        <p>Upload photos from your Computer</p>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="mobile-dev">
                    <a href="upload-phone.php">
                        <h4>Mobile Device</h4>
                        <img src="images/mobile.png" alt="">
                        <p>Upload photos from your phone or tablet.</p>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="cloud-dev">
                    <a href="upload-cloud.php">
                        <h4>Cloud Storage</h4>
                        <img src="images/cloud.png" alt="">
                        <p>Access photos from Facebook, Instagram, Google, and more.</p>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<footer>
    <section class="footer">
        <div class="container">
            <div class="fotter-main">
                <p>Bay Color Photo Lab copyright 2022</p>
                <p>A <a href="https://siteorigin.com/">SiteOrigin</a> Theme</p>
            </div>
        </div>
    </section>
</footer>
<script src="js/jquery.min.js"></script>
<script  src="js/bootstrap.min.js"></script>
<script  src="js/slick.js"></script>
<!--<script  src="js/jquery.fancybox.min.js"></script>-->
<script  src="js/wow.js"></script>
<script  src="js/functions.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.js"
    integrity="sha512-WNZwVebQjhSxEzwbettGuQgWxbpYdoLf7mH+25A7sfQbbxKeS5SQ9QBf97zOY4nOlwtksgDA/czSTmfj4DUEiQ=="
    crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://unpkg.com/aos@next/dist/aos.js"></script>
<script src="https://unpkg.com/boxicons@2.1.4/dist/boxicons.js"></script>


<script>
    AOS.init();
</script>

</body>

</html>