@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title">{{ _lang('Update Size Details') }}</span>
			</div>
			<div class="card-body">
				<form method="post" class="validate" autocomplete="off" action="{{ action('SizesController@update', $id) }}" enctype="multipart/form-data">
					{{ csrf_field()}}
					<input name="_method" type="hidden" value="PATCH">				
					<div class="row">
					    <div class="col-md-12">
							<div class="form-group">
								<label class="control-label">{{ _lang('Paper') }}</label>
								<select class="form-control" name="paper_id">
								    @if($paper->paper_id != '')
								        <option value="{{ $paper->paper_id }}">{{ getPaperName($paper->paper_id)->name }}</option>
								    @endif
									@foreach(App\Paper::all() as $data2)
									    <option value="{{ $data2->id }}">{{ $data2->name }}</option>
									@endforeach
								</select>
							</div>
						</div>
						
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label">{{ _lang('Size') }}</label>						
								<input type="text" class="form-control" name="name" value="{{ $paper->size }}" required>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label">{{ _lang('Price') }}</label>						
								<input type="text" class="form-control" name="price" value="{{ $paper->price }}" required>
							</div>
						</div>
						
						<div class="col-md-12">
							<div class="form-group">
								<button type="submit" class="btn btn-primary">{{ _lang('Update') }}</button>
							</div>
						</div>
					</div>

						
							
					</div>	
				</form>
			</div>
		</div>
	</div>
</div>

@endsection


