@extends('layouts.app')

@section('content')

<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title">{{ _lang('Papers List') }}</span>
				<a class="btn btn-primary btn-xs ml-auto ajax-modal" data-title="{{ _lang('Create New Paper') }}" href="{{ route('paper.create') }}">{{ _lang('Create New Paper') }}</a>
			</div>
			<div class="card-body">
				<table id="users_table" class="table table-bordered data-table">
					<thead>
					    <tr>
							<th class="text-center">#</th>
						    <th>{{ _lang('Name') }}</th>
							<!--<th>{{ _lang('Price') }}</th>-->
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
					    @foreach($papers as $paper)
					    <tr>
							<td class=''>{{ $loop->index+1 }}</td>
							<td class='name'>{{ $paper->name }}</td>
							<!--<td class='email'>${{ $paper->price }}</td>-->
							<td class="text-center">
								<div class="dropdown">
								  <button class="btn btn-light dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  {{ _lang('Action') }}
								  <i class="fas fa-angle-down"></i>
								  </button>
								  <form action="{{ action('PaperController@destroy', $paper['id']) }}" method="post">
									{{ csrf_field() }}
									<input name="_method" type="hidden" value="DELETE">
									
									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="{{ action('PaperController@edit', $paper['id']) }}" data-title="{{ _lang('Update Customer Details') }}" class="dropdown-item dropdown-edit ajax-modal"><i class="mdi mdi-pencil"></i> {{ _lang('Edit') }}</a>
										<button class="btn-remove dropdown-item" type="submit"><i class="mdi mdi-delete"></i> {{ _lang('Delete') }}</button>
									</div>
								  </form>
								</div>
							</td>
					    </tr>
					    @endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

@endsection