@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-9">
		<div class="card">
		    <div class="card-header">
				<span class="panel-title">{{ _lang('View Order Details') }}</span>
			</div>
			
			<div class="card-body">

			    <div class="receipt-content">
					<div class="row">
						<div class="col-md-12">
							<div class="invoice-wrapper">
								<h2>Order # {{ $order->id }}</h2>
								<div class="payment-details">
									<div class="row">
										<div class="col-sm-4">
											<span>{{ _lang('Billing Details') }}</span>
											<strong>
												{{ $order->name }}
											</strong>
											<p>
												{{ $order->email }}
												{{ $order->address }}<br>
												{{ $order->city }}<br>
												{{ $order->state }}, {{ $order->country }} <br>
												{{ $order->postal_code }}
											</p>
										</div>

										<div class="col-sm-4">
											<span>{{ _lang('Shipping Address') }}</span>
											<p>
												{{ $order->email }}
												{{ $order->address }}<br>
												{{ $order->city }}<br>
												{{ $order->state }}, {{ $order->country }} <br>
												{{ $order->postal_code }}
											</p>
										</div>

										<div class="col-sm-4 text-right">
											<span>{{ _lang('Payment To') }}</span>
											<strong>
												{{ get_option('company_name') }}
											</strong>
											<p>
												{{ get_option('email') }}<br>
												{{ get_option('phone') }}<br>
												{!! xss_clean(get_option('address')) !!} <br>
											</p>
										</div>
									</div>
								</div>

								<div class="line-items">
									<table border="1" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Image Name</th> <!-- Added header for Image Name -->
                                                <th>Type</th>
                                                <th>Qty</th>
                                                <th>Size</th>
                                                <th>Price</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                // Ensure the string is split into lines
                                                $items = preg_split('/\r\n|\r|\n/', $order->order_info); // Splitting by line breaks
                                            @endphp
                                    
                                            @foreach ($items as $item)
                                                @php
                                                    $item = explode('-', $item);
                                                @endphp
                                                @if ($item)
                                                    <tr style="border:1px solid #000;">
                                                        <td style="border:1px solid #000;">{{ $item[0] }}</td> <!-- Image Name -->
                                                        <td style="border:1px solid #000;">{{ $item[1] }}</td>
                                                        @php
                                                            $item2 = splitLastX($item[2])
                                                        @endphp
                                                        <td style="border:1px solid #000;">{{ $item2[0] }}</td> <!-- Qty -->
                                                        <td style="border:1px solid #000;">{{ $item2[1] }}</td> <!-- Size -->
                                                        <td style="border:1px solid #000;">{{ $item[3] }}</td> <!-- Price -->
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
									<div class="total text-right">
										@if($order->images != '')
										<div class="row">
											@foreach(json_decode($order->images) as $image)
												<div class="col-md-3">
													<img src="{{ asset('public/'.$image) }}" alt="Uploaded Image" class="img-thumbnail thumbnail">  
													<p>{{ str_replace("uploads/users/","", $image); }}</p>
													<a href="{{ asset('public/'.$image) }}" download="{{ asset('public/'.$image) }}" id="download-all"><i class="fa-solid fa-download"></i> Download</a>
												</div>
											@endforeach
										</div>
										
										@endif
											<h1 id="totall" style="background: #000;color: #fff;"><span id="total-text">{{ _lang('Total : ') }}</span><span id="total-price">${{ $order->total }}</span></h1>
									</div>

								</div>
							</div>
						</div>
					</div>
				</div>  

			</div>
	    </div>
	</div>
</div>

@endsection
@section('js-script')
<script>
    $('#download-all').click(function() {
		console.log('looplapata')

        let images = @json($order->images);
        images.forEach(function(image) {
            const link = document.createElement('a');
            link.href = '{{ asset('public/') }}' + '/' + image; // Full path to the image
            link.download = image.split('/').pop(); // Extract filename for download
            document.body.appendChild(link); // Append link to the body
            link.click(); // Trigger download
            document.body.removeChild(link); // Remove link after downloading
        });
    });
</script>
@endsection