@extends('layouts.app')

@section('content')

<div class="row">
	<div class="col-lg-12">
		<div class="card no-export">
		    <div class="card-header">
				<span class="panel-title">{{ _lang('Order List') }}</span>
			</div>
			<div class="card-body">
				<table id="orders_table" class="table table-bordered">
					<thead>
					    <tr>
							<th>{{ _lang('ID') }}</th>
							<th>{{ _lang('Customer Name') }}</th>
							<th>{{ _lang('Provided Images') }}</th>
							<th>{{ _lang('Order Summery') }}</th>
							<th>{{ _lang('Total') }}</th>
							<th>{{ _lang('Status') }}</th>
							<th>{{ _lang('Payment') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
						@foreach(App\PrintImages::all() as $data)
							<tr>
								<td>{{ $loop->index+1 }}</td>
								<td>{{ $data->name }}</td>
								<td>
									<ul>
										@foreach(json_decode($data->images) as $dt)
											<li style="display: inline-block;width:10%;"> <img src="{{ asset('public/'.$dt) }}" alt="Uploaded Image" class="img-thumbnail thumbnail"></li>
										@endforeach
									</ul>
								</td>
								<td>{{ $data->order_info }}</td>
								<td>${{ $data->total == '' ? '0' : $data->total  }}</td>
								<td>{{ $data->status }}</td>
								<td>{{ $data->payment_status }}</td>
								<td>
									<div class="dropdown">
										<button class="btn btn-light dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										{{ _lang('Action') }}
										<i class="fas fa-angle-down"></i>
										</button>
										<form action="{{ action('OrderController@destroy', $data['id']) }}" method="post">
										  {{ csrf_field() }}
										  <input name="_method" type="hidden" value="DELETE">
										  
										  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
											  <a href="{{ action('OrderController@show', $data['id']) }}" class="dropdown-item dropdown-edit dropdown-edit"><i class="mdi mdi-pencil"></i> {{ _lang('View Order') }}</a>
											  <button class="btn-remove dropdown-item" type="submit"><i class="mdi mdi-delete"></i> {{ _lang('Delete') }}</button>
										  </div>
										</form>
									  </div>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

@endsection


@section('js-script')
<script>
    $('#orders_table').DataTable({
	
	});
</script>
@endsection
