const imagesMap = new Map();

const imgSelectorFun = (inputImgs, gForm, showTo) => {
  const imagesData = imagesMap.get(showTo) || [];
  let image = inputImgs.files;

  for (let i = 0; i < image.length; i++) {
    imagesData.push({
      name: image[i].name,
      url: URL.createObjectURL(image[i]),
      file: image[i],
    });
  }
  imagesMap.set(showTo, imagesData);

  gForm.reset();
  document.querySelector(`${showTo}`).innerHTML = showImgFun(
    imagesData,
    showTo
  );
};

const showImgFun = (yimages, showTo) => {
  let image = "";
  if (yimages.length > 0) {
    yimages.forEach((ele, i) => {
      image += `<div class="col img-card">
        <img src="${ele.url}">
        <span onclick="deleteImgFun(${i}, '${showTo}')">
          <i class="fa-solid fa-xmark"></i>
        </span>
      </div>`;
    });
    return image;
  } else {
    return `<div>
             <h6 class="empty-hd"><i class="fa-regular fa-images"></i> <br>
                        No Product Images are uploaded</h6>
            </div>`;
  }
};

const deleteImgFun = (i, showTo) => {
  const imagesData = imagesMap.get(showTo);
  imagesData.splice(i, 1);
  imagesMap.set(showTo, imagesData);
  document.querySelector(`${showTo}`).innerHTML = showImgFun(
    imagesData,
    showTo
  );
};

let galleryForm = document.querySelectorAll(".gallery-form");
galleryForm.forEach((gForm) => {
  let uploadImgBtn = gForm.querySelector("button");
  let inputImgs = gForm.querySelector("input");
  let showTo = gForm.getAttribute("showAt");

  uploadImgBtn.addEventListener("click", () => inputImgs.click());

  inputImgs.addEventListener("change", (event) =>
    imgSelectorFun(event.target, gForm, showTo)
  );
});