<?php

namespace App\Http\Controllers\Website;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Utilities\CheckoutTax;
use App\Services\OrderService;
use App\User;
use App\CustomerAddress;
use App\Order;
use App\PrintImages;
use Validator;
use Cart;
use Auth;
use Hash;
use DB;

class CheckoutController extends Controller
{
  
    private $theme;

    public function __construct()
    { 
        $this->theme = env('ACTIVE_THEME','baycolorlab');        
        date_default_timezone_set(get_option('timezone','Asia/Dhaka'));       
    }

    public function apply_tax(Request $request, $shipping_state, $billing_state){
    	Cart::removeConditionsByType('tax');
    	
    	if($shipping_state != '' && $billing_state != ''){
    		CheckoutTax::apply_tax($shipping_state, $billing_state);
    	}	

    	if( ! $request->ajax()){
           return back();
        }else{
           return view("theme.$this->theme.components.checkout-cart");
        }
    }

    public function make_order(Request $request){

        $data = PrintImages::find($request->order_id);
        $data->name = $request->name;
        $data->email = $request->email;
        $data->address = $request->address;
        $data->city = $request->city;
        $data->state = $request->state;
        $data->country = $request->country;
        $data->postal_code = $request->postal_code;
        $data->save();

        if( $data->total > 0 ){
            return redirect('/payment/'.encrypt($data->id));
        }

        return back()->with('error',_lang('Error Occured, Please try again !'));
    	
    }

    public function payment(Request $request, $order_id){
        $order_id = decrypt($order_id);
        $data = PrintImages::find($order_id);
        
        if($data->payment_status == NULL){
            return view("theme.$this->theme.payment",compact('data'));
        }

        return back();  
    }

}