<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Sizes;

class SizesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $papers = Sizes::all();
        
        return view('backend.sizes.list',compact('papers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.sizes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new Sizes();

        $data->paper_id = $request->paper_id;
        $data->size = $request->name;
        $data->price = $request->price;
        $data->save();
        
        $papers = Sizes::all();
        return view('backend.sizes.list',compact('papers'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
       $paper = Sizes::find($id);
        
       return view('backend.sizes.edit',compact('paper','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Sizes::find($id);
        $data->paper_id = $request->paper_id;
        $data->size = $request->name;
        $data->price = $request->price;
        $data->save();
        
        $papers = Sizes::all();
        return view('backend.sizes.list',compact('papers'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Sizes::find($id);
        $data->delete();
        
        return redirect()->back();
    }
}
